/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.receipt;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;
import no.digipost.api.datatypes.types.Barcode;
import no.digipost.api.datatypes.types.receipt.Customer;
import no.digipost.api.datatypes.types.receipt.Delivery;
import no.digipost.api.datatypes.types.receipt.Payment;
import no.digipost.api.datatypes.types.receipt.ReceiptLine;
import no.digipost.api.datatypes.types.receipt.TaxiDetails;

@XmlRootElement
@Description(value="Receipt represents a document containing details about a purchase")
public final class Receipt
implements DataType {
    @XmlElement
    @Description(value="The ID of this receipt in the system it was imported from")
    @Size(max=50)
    private final @Size(max=50) String receiptId;
    @XmlElement
    @Description(value="The original receipt number from the store")
    private final String receiptNumber;
    @XmlElement(required=true)
    @NotNull
    @Description(value="When the purchase was made. ISO8601 full DateTime")
    private final ZonedDateTime purchaseTime;
    @XmlElement(required=true)
    @NotNull
    @Description(value="The total price paid for the item(s) purchased")
    private final BigDecimal totalPrice;
    @NotNull
    @XmlElement(required=true)
    @Description(value="The total vat amount for the item(s) purchased")
    private final BigDecimal totalVat;
    @XmlElement(name="currency")
    @Size(max=3)
    @Description(value="Currency of the price, ISO4217. Example: NOK")
    private final @Size(max=3) String currencyCode;
    @XmlElement
    @Description(value="Identifier for cashier who made the sale")
    @Size(max=100)
    private final @Size(max=100) String cashier;
    @XmlElement
    @Description(value="Identifier for the register where the purchase was made")
    @Size(max=50)
    private final @Size(max=50) String register;
    @XmlElement(name="merchant-chain")
    @Description(value="Optional name of the chain that the merchant is a part of")
    private final String merchantChain;
    @XmlElement(name="merchant-name", required=true)
    @NotNull
    @Size(max=150)
    @Description(value="Name of the store or merchant. Example: Gr\u00fcnerl\u00f8kka Hip Coffee")
    private final @NotNull @Size(max=150) String merchantName;
    @XmlElement(name="merchant-phone-number")
    private final String merchantPhoneNumber;
    @XmlElement(name="merchant-address")
    @Description(value="Address of the store or merchant")
    @Valid
    private final Address merchantAddress;
    @XmlElement(name="orgnumber")
    @Description(value="Organization number of the sales point")
    private final String organizationNumber;
    @XmlElement
    private final Barcode barcode;
    @XmlElement
    @Description(value="List of payments done during this purchase")
    @Valid
    private final List<Payment> payments;
    @XmlElement
    @Description(value="The individual items sold")
    @Valid
    private final List<ReceiptLine> items;
    @XmlElement
    @Description(value="Details for taxi receipts")
    @Valid
    private final TaxiDetails taxiDetails;
    @XmlElement
    @Description(value="Name and address of customer")
    private final Customer customer;
    @XmlElement
    @Description(value="Name and address of delivery")
    private final Delivery delivery;
    @XmlElement(name="order-number")
    private final String orderNumber;
    @XmlElement(name="membership-number")
    private final String membershipNumber;
    @XmlElement
    private final String comment;
    public static Receipt EXAMPLE = new Receipt("F96B6805-2453-478A-B58B-CCDFA07E21ED", "364567", ZonedDateTime.of(2018, 5, 27, 10, 0, 0, 0, ZoneId.systemDefault()), ReceiptLine.EXAMPLE.getTotalPrice(), ReceiptLine.EXAMPLE.getTotalVat(), "NOK", "Benny", "15", "7F5A1EFF-ECAE-48A7-A07F-38D87576F815", "Gr\u00fcnerl\u00f8kka Hip Coffee", "12345678", Address.EXAMPLE, "123456789", Barcode.EXAMPLE, Collections.singletonList(Payment.EXAMPLE), Collections.singletonList(ReceiptLine.EXAMPLE), TaxiDetails.EXAMPLE, Customer.EXAMPLE, Delivery.EXAMPLE, "123456", "HG1234HH8778", "Hip Coffee to the good citizens of L\u00f8kka");

    public String getReceiptId() {
        return this.receiptId;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public ZonedDateTime getPurchaseTime() {
        return this.purchaseTime;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public BigDecimal getTotalVat() {
        return this.totalVat;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCashier() {
        return this.cashier;
    }

    public String getRegister() {
        return this.register;
    }

    public String getMerchantChain() {
        return this.merchantChain;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getMerchantPhoneNumber() {
        return this.merchantPhoneNumber;
    }

    public Address getMerchantAddress() {
        return this.merchantAddress;
    }

    public String getOrganizationNumber() {
        return this.organizationNumber;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public List<ReceiptLine> getItems() {
        return this.items;
    }

    public TaxiDetails getTaxiDetails() {
        return this.taxiDetails;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getMembershipNumber() {
        return this.membershipNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Receipt)) {
            return false;
        }
        Receipt other = (Receipt)o;
        String this$receiptId = this.getReceiptId();
        String other$receiptId = other.getReceiptId();
        if (this$receiptId == null ? other$receiptId != null : !this$receiptId.equals(other$receiptId)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        ZonedDateTime this$purchaseTime = this.getPurchaseTime();
        ZonedDateTime other$purchaseTime = other.getPurchaseTime();
        if (this$purchaseTime == null ? other$purchaseTime != null : !((Object)this$purchaseTime).equals(other$purchaseTime)) {
            return false;
        }
        BigDecimal this$totalPrice = this.getTotalPrice();
        BigDecimal other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !((Object)this$totalPrice).equals(other$totalPrice)) {
            return false;
        }
        BigDecimal this$totalVat = this.getTotalVat();
        BigDecimal other$totalVat = other.getTotalVat();
        if (this$totalVat == null ? other$totalVat != null : !((Object)this$totalVat).equals(other$totalVat)) {
            return false;
        }
        String this$currencyCode = this.getCurrencyCode();
        String other$currencyCode = other.getCurrencyCode();
        if (this$currencyCode == null ? other$currencyCode != null : !this$currencyCode.equals(other$currencyCode)) {
            return false;
        }
        String this$cashier = this.getCashier();
        String other$cashier = other.getCashier();
        if (this$cashier == null ? other$cashier != null : !this$cashier.equals(other$cashier)) {
            return false;
        }
        String this$register = this.getRegister();
        String other$register = other.getRegister();
        if (this$register == null ? other$register != null : !this$register.equals(other$register)) {
            return false;
        }
        String this$merchantChain = this.getMerchantChain();
        String other$merchantChain = other.getMerchantChain();
        if (this$merchantChain == null ? other$merchantChain != null : !this$merchantChain.equals(other$merchantChain)) {
            return false;
        }
        String this$merchantName = this.getMerchantName();
        String other$merchantName = other.getMerchantName();
        if (this$merchantName == null ? other$merchantName != null : !this$merchantName.equals(other$merchantName)) {
            return false;
        }
        String this$merchantPhoneNumber = this.getMerchantPhoneNumber();
        String other$merchantPhoneNumber = other.getMerchantPhoneNumber();
        if (this$merchantPhoneNumber == null ? other$merchantPhoneNumber != null : !this$merchantPhoneNumber.equals(other$merchantPhoneNumber)) {
            return false;
        }
        Address this$merchantAddress = this.getMerchantAddress();
        Address other$merchantAddress = other.getMerchantAddress();
        if (this$merchantAddress == null ? other$merchantAddress != null : !((Object)this$merchantAddress).equals(other$merchantAddress)) {
            return false;
        }
        String this$organizationNumber = this.getOrganizationNumber();
        String other$organizationNumber = other.getOrganizationNumber();
        if (this$organizationNumber == null ? other$organizationNumber != null : !this$organizationNumber.equals(other$organizationNumber)) {
            return false;
        }
        Barcode this$barcode = this.getBarcode();
        Barcode other$barcode = other.getBarcode();
        if (this$barcode == null ? other$barcode != null : !((Object)this$barcode).equals(other$barcode)) {
            return false;
        }
        List<Payment> this$payments = this.getPayments();
        List<Payment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        List<ReceiptLine> this$items = this.getItems();
        List<ReceiptLine> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        TaxiDetails this$taxiDetails = this.getTaxiDetails();
        TaxiDetails other$taxiDetails = other.getTaxiDetails();
        if (this$taxiDetails == null ? other$taxiDetails != null : !((Object)this$taxiDetails).equals(other$taxiDetails)) {
            return false;
        }
        Customer this$customer = this.getCustomer();
        Customer other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !((Object)this$customer).equals(other$customer)) {
            return false;
        }
        Delivery this$delivery = this.getDelivery();
        Delivery other$delivery = other.getDelivery();
        if (this$delivery == null ? other$delivery != null : !((Object)this$delivery).equals(other$delivery)) {
            return false;
        }
        String this$orderNumber = this.getOrderNumber();
        String other$orderNumber = other.getOrderNumber();
        if (this$orderNumber == null ? other$orderNumber != null : !this$orderNumber.equals(other$orderNumber)) {
            return false;
        }
        String this$membershipNumber = this.getMembershipNumber();
        String other$membershipNumber = other.getMembershipNumber();
        if (this$membershipNumber == null ? other$membershipNumber != null : !this$membershipNumber.equals(other$membershipNumber)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $receiptId = this.getReceiptId();
        result = result * 59 + ($receiptId == null ? 43 : $receiptId.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        ZonedDateTime $purchaseTime = this.getPurchaseTime();
        result = result * 59 + ($purchaseTime == null ? 43 : ((Object)$purchaseTime).hashCode());
        BigDecimal $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : ((Object)$totalPrice).hashCode());
        BigDecimal $totalVat = this.getTotalVat();
        result = result * 59 + ($totalVat == null ? 43 : ((Object)$totalVat).hashCode());
        String $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : $currencyCode.hashCode());
        String $cashier = this.getCashier();
        result = result * 59 + ($cashier == null ? 43 : $cashier.hashCode());
        String $register = this.getRegister();
        result = result * 59 + ($register == null ? 43 : $register.hashCode());
        String $merchantChain = this.getMerchantChain();
        result = result * 59 + ($merchantChain == null ? 43 : $merchantChain.hashCode());
        String $merchantName = this.getMerchantName();
        result = result * 59 + ($merchantName == null ? 43 : $merchantName.hashCode());
        String $merchantPhoneNumber = this.getMerchantPhoneNumber();
        result = result * 59 + ($merchantPhoneNumber == null ? 43 : $merchantPhoneNumber.hashCode());
        Address $merchantAddress = this.getMerchantAddress();
        result = result * 59 + ($merchantAddress == null ? 43 : ((Object)$merchantAddress).hashCode());
        String $organizationNumber = this.getOrganizationNumber();
        result = result * 59 + ($organizationNumber == null ? 43 : $organizationNumber.hashCode());
        Barcode $barcode = this.getBarcode();
        result = result * 59 + ($barcode == null ? 43 : ((Object)$barcode).hashCode());
        List<Payment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        List<ReceiptLine> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        TaxiDetails $taxiDetails = this.getTaxiDetails();
        result = result * 59 + ($taxiDetails == null ? 43 : ((Object)$taxiDetails).hashCode());
        Customer $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : ((Object)$customer).hashCode());
        Delivery $delivery = this.getDelivery();
        result = result * 59 + ($delivery == null ? 43 : ((Object)$delivery).hashCode());
        String $orderNumber = this.getOrderNumber();
        result = result * 59 + ($orderNumber == null ? 43 : $orderNumber.hashCode());
        String $membershipNumber = this.getMembershipNumber();
        result = result * 59 + ($membershipNumber == null ? 43 : $membershipNumber.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "Receipt(receiptId=" + this.getReceiptId() + ", receiptNumber=" + this.getReceiptNumber() + ", purchaseTime=" + this.getPurchaseTime() + ", totalPrice=" + this.getTotalPrice() + ", totalVat=" + this.getTotalVat() + ", currencyCode=" + this.getCurrencyCode() + ", cashier=" + this.getCashier() + ", register=" + this.getRegister() + ", merchantChain=" + this.getMerchantChain() + ", merchantName=" + this.getMerchantName() + ", merchantPhoneNumber=" + this.getMerchantPhoneNumber() + ", merchantAddress=" + this.getMerchantAddress() + ", organizationNumber=" + this.getOrganizationNumber() + ", barcode=" + this.getBarcode() + ", payments=" + this.getPayments() + ", items=" + this.getItems() + ", taxiDetails=" + this.getTaxiDetails() + ", customer=" + this.getCustomer() + ", delivery=" + this.getDelivery() + ", orderNumber=" + this.getOrderNumber() + ", membershipNumber=" + this.getMembershipNumber() + ", comment=" + this.getComment() + ")";
    }

    @ConstructorProperties(value={"receiptId", "receiptNumber", "purchaseTime", "totalPrice", "totalVat", "currencyCode", "cashier", "register", "merchantChain", "merchantName", "merchantPhoneNumber", "merchantAddress", "organizationNumber", "barcode", "payments", "items", "taxiDetails", "customer", "delivery", "orderNumber", "membershipNumber", "comment"})
    public Receipt(String receiptId, String receiptNumber, ZonedDateTime purchaseTime, BigDecimal totalPrice, BigDecimal totalVat, String currencyCode, String cashier, String register, String merchantChain, String merchantName, String merchantPhoneNumber, Address merchantAddress, String organizationNumber, Barcode barcode, List<Payment> payments, List<ReceiptLine> items, TaxiDetails taxiDetails, Customer customer, Delivery delivery, String orderNumber, String membershipNumber, String comment) {
        this.receiptId = receiptId;
        this.receiptNumber = receiptNumber;
        this.purchaseTime = purchaseTime;
        this.totalPrice = totalPrice;
        this.totalVat = totalVat;
        this.currencyCode = currencyCode;
        this.cashier = cashier;
        this.register = register;
        this.merchantChain = merchantChain;
        this.merchantName = merchantName;
        this.merchantPhoneNumber = merchantPhoneNumber;
        this.merchantAddress = merchantAddress;
        this.organizationNumber = organizationNumber;
        this.barcode = barcode;
        this.payments = payments;
        this.items = items;
        this.taxiDetails = taxiDetails;
        this.customer = customer;
        this.delivery = delivery;
        this.orderNumber = orderNumber;
        this.membershipNumber = membershipNumber;
        this.comment = comment;
    }

    private Receipt() {
        this.receiptId = null;
        this.receiptNumber = null;
        this.purchaseTime = null;
        this.totalPrice = null;
        this.totalVat = null;
        this.currencyCode = null;
        this.cashier = null;
        this.register = null;
        this.merchantChain = null;
        this.merchantName = null;
        this.merchantPhoneNumber = null;
        this.merchantAddress = null;
        this.organizationNumber = null;
        this.barcode = null;
        this.payments = null;
        this.items = null;
        this.taxiDetails = null;
        this.customer = null;
        this.delivery = null;
        this.orderNumber = null;
        this.membershipNumber = null;
        this.comment = null;
    }

    public Receipt withReceiptId(String receiptId) {
        return this.receiptId == receiptId ? this : new Receipt(receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withReceiptNumber(String receiptNumber) {
        return this.receiptNumber == receiptNumber ? this : new Receipt(this.receiptId, receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withPurchaseTime(ZonedDateTime purchaseTime) {
        return this.purchaseTime == purchaseTime ? this : new Receipt(this.receiptId, this.receiptNumber, purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withTotalPrice(BigDecimal totalPrice) {
        return this.totalPrice == totalPrice ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withTotalVat(BigDecimal totalVat) {
        return this.totalVat == totalVat ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withCurrencyCode(String currencyCode) {
        return this.currencyCode == currencyCode ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withCashier(String cashier) {
        return this.cashier == cashier ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withRegister(String register) {
        return this.register == register ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withMerchantChain(String merchantChain) {
        return this.merchantChain == merchantChain ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withMerchantName(String merchantName) {
        return this.merchantName == merchantName ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withMerchantPhoneNumber(String merchantPhoneNumber) {
        return this.merchantPhoneNumber == merchantPhoneNumber ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withMerchantAddress(Address merchantAddress) {
        return this.merchantAddress == merchantAddress ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withOrganizationNumber(String organizationNumber) {
        return this.organizationNumber == organizationNumber ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withBarcode(Barcode barcode) {
        return this.barcode == barcode ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withPayments(List<Payment> payments) {
        return this.payments == payments ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withItems(List<ReceiptLine> items) {
        return this.items == items ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withTaxiDetails(TaxiDetails taxiDetails) {
        return this.taxiDetails == taxiDetails ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withCustomer(Customer customer) {
        return this.customer == customer ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, customer, this.delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withDelivery(Delivery delivery) {
        return this.delivery == delivery ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, delivery, this.orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withOrderNumber(String orderNumber) {
        return this.orderNumber == orderNumber ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, orderNumber, this.membershipNumber, this.comment);
    }

    public Receipt withMembershipNumber(String membershipNumber) {
        return this.membershipNumber == membershipNumber ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, membershipNumber, this.comment);
    }

    public Receipt withComment(String comment) {
        return this.comment == comment ? this : new Receipt(this.receiptId, this.receiptNumber, this.purchaseTime, this.totalPrice, this.totalVat, this.currencyCode, this.cashier, this.register, this.merchantChain, this.merchantName, this.merchantPhoneNumber, this.merchantAddress, this.organizationNumber, this.barcode, this.payments, this.items, this.taxiDetails, this.customer, this.delivery, this.orderNumber, this.membershipNumber, comment);
    }
}

