/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.documentation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import no.digipost.api.datatypes.documentation.ComplexType;
import no.digipost.api.datatypes.documentation.FieldInfo;
import no.digipost.api.datatypes.documentation.FieldType;
import no.digipost.api.datatypes.marshalling.DataTypesJsonMapper;

public class MarkdownPrinter {
    private static String LF = System.lineSeparator();
    private static String LLF = LF + LF;
    private final JAXBContext jaxb;
    private final boolean printJsonExamples;

    public MarkdownPrinter(JAXBContext jaxbContext, boolean printJsonExamples) {
        this.jaxb = jaxbContext;
        this.printJsonExamples = printJsonExamples;
    }

    public String print(List<ComplexType> typeInfos) {
        return this.printHeader(typeInfos) + LLF + this.printTypes(typeInfos) + LF;
    }

    private String printTypes(List<ComplexType> typeInfos) {
        return typeInfos.stream().map(this::printTypeOverview).collect(Collectors.joining(LLF));
    }

    private String printHeader(List<ComplexType> typeInfos) {
        return this.heading(2, "Data types") + LLF + "|Type|Description|" + LF + "|----|-----------|" + LF + typeInfos.stream().map(t -> "|" + this.printLink((ComplexType)t, (ComplexType)t) + "|" + t.getDescription() + "|").collect(Collectors.joining(LF));
    }

    private String printTypeOverview(ComplexType typeInfo) {
        return this.heading(2, typeInfo.getTypeName()) + LLF + typeInfo.getDescription() + LLF + this.printComplementedByInformation(typeInfo) + this.heading(3, "Fields") + LLF + this.printFields(typeInfo, typeInfo.getFields(), new HashSet<ComplexType>()) + LLF + (this.printJsonExamples ? this.printJsonExample(typeInfo.getExample()) + LLF : "") + this.printXmlExample(typeInfo.getExample());
    }

    private String printComplementedByInformation(ComplexType type) {
        List<ComplexType> complementables = type.getComplementables();
        if (!complementables.isEmpty()) {
            return "### Complemented by: " + LF + complementables.stream().map(s -> this.printLink((ComplexType)s, (ComplexType)s)).collect(Collectors.joining(", ")) + LLF;
        }
        return "";
    }

    private String printXmlExample(Object example) {
        try {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.jaxb.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(example, (Writer)writer);
            return this.heading(3, "XML") + LLF + this.code("xml", writer.toString().trim());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private String code(String type, String s) {
        return "```" + type + LF + s + LF + "```";
    }

    private String printJsonExample(Object example) {
        try {
            return this.heading(3, "JSON") + LLF + this.code("json", DataTypesJsonMapper.getMapper().configure(SerializationFeature.INDENT_OUTPUT, true).writeValueAsString(example).trim());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String printTypeInfo(ComplexType parent, ComplexType type, Set<ComplexType> printed) {
        printed.add(type);
        return this.heading(3, parent.getTypeName() + "." + type.getTypeName()) + LLF + (type.getType().isEnum() ? this.printEnum(type.getType()) : this.printFields(parent, type.getFields(), printed));
    }

    private String printEnum(Class<?> type) {
        String desc = "Valid values:";
        return desc + LLF + Stream.of(type.getEnumConstants()).map(String::valueOf).collect(Collectors.joining(LF + "* ", "* ", ""));
    }

    private String printFields(ComplexType parent, List<FieldInfo> fields, Set<ComplexType> printed) {
        String subTypes = fields.stream().map(FieldInfo::getType).filter(FieldType::isComplex).map(t -> (ComplexType)t).filter(o -> !printed.contains(o)).map(type -> this.printTypeInfo(parent, (ComplexType)type, printed)).collect(Collectors.joining(LLF));
        return "|Name|Type|Required|Description|" + LF + "|----|----|--------|-----------|" + LF + fields.stream().map(f -> this.printField(parent, (FieldInfo)f)).collect(Collectors.joining(LF)) + (subTypes.isEmpty() ? subTypes : LLF + subTypes);
    }

    private String printField(ComplexType parent, FieldInfo f) {
        String type = f.getType().isComplex() ? this.printLink(parent, (ComplexType)f.getType()) : f.getType().getTypeName();
        return "|" + f.getName() + "|" + type + "|" + (f.isMandatory() ? "yes" : "no") + "|" + f.getDescription() + "|";
    }

    private String printLink(ComplexType parent, ComplexType field) {
        String prefix = !parent.hasSameNameAs(field) ? parent.getTypeName().toLowerCase().replaceAll(" ", "-") : "";
        return "[" + field.getTypeName() + "](#" + prefix + field.getTypeName().toLowerCase().replaceAll(" ", "-") + ")";
    }

    private String heading(int level, String heading) {
        return Stream.generate(() -> "#").limit(level).collect(Collectors.joining()) + " " + heading;
    }
}

