/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;
import no.digipost.api.datatypes.types.Info;

@XmlRootElement
@Description(value="Appointment represents a meeting set for a specific place and time")
public final class Appointment
implements DataType {
    @XmlElement(name="start-time", required=true)
    @NotNull
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime startTime;
    @XmlElement(name="end-time")
    @Description(value="ISO8601 full DateTime. Default value 30 minutes after startTime")
    private final ZonedDateTime endTime;
    @XmlElement(name="arrival-time")
    @Description(value="Free text but can contain a ISO8601 DateTime. Example: Please arrive 15 minutes early")
    @Size(max=150)
    private final @Size(max=150) String arrivalTime;
    @XmlElement
    @Description(value="The name of the place. Example: Oslo City R\u00f8ntgen")
    @Size(max=150)
    private final @Size(max=150) String place;
    @XmlElement
    @Valid
    private final Address address;
    @XmlElement(name="sub-title")
    @Size(max=150)
    @Description(value="Example: MR-unders\u00f8kelse av h\u00f8yre kne")
    private final @Size(max=150) String subTitle;
    @XmlElement
    @Valid
    @Size(max=2)
    @Description(value="Additional sections of information (max 2) with a title and text")
    private final @Valid @Size(max=2) List<Info> info;
    public static Appointment EXAMPLE = new Appointment(ZonedDateTime.of(2017, 6, 27, 10, 0, 0, 0, ZoneId.systemDefault()), ZonedDateTime.of(2017, 6, 27, 11, 0, 0, 0, ZoneId.systemDefault()), "Oppm\u00f8te senest 15 minutter f\u00f8r timen", "Oslo City R\u00f8ntgen", Address.EXAMPLE, "Unders\u00f8ke smerter i ryggen", Collections.singletonList(new Info("Informasjon om Oslo City R\u00f8ntgen", "Oslo City R\u00f8ntgen er et spesialistsenter for avansert bildediagnostikk.")));

    @Override
    public Appointment withDefaultsForMissingOptionalValues() {
        return this.endTime == null ? this.withEndTime(this.startTime.plusMinutes(30L)) : this;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public String getArrivalTime() {
        return this.arrivalTime;
    }

    public String getPlace() {
        return this.place;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public List<Info> getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Appointment)) {
            return false;
        }
        Appointment other = (Appointment)o;
        ZonedDateTime this$startTime = this.getStartTime();
        ZonedDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        ZonedDateTime this$endTime = this.getEndTime();
        ZonedDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$arrivalTime = this.getArrivalTime();
        String other$arrivalTime = other.getArrivalTime();
        if (this$arrivalTime == null ? other$arrivalTime != null : !this$arrivalTime.equals(other$arrivalTime)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        List<Info> this$info = this.getInfo();
        List<Info> other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        ZonedDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $arrivalTime = this.getArrivalTime();
        result = result * 59 + ($arrivalTime == null ? 43 : $arrivalTime.hashCode());
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        List<Info> $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "Appointment(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", arrivalTime=" + this.getArrivalTime() + ", place=" + this.getPlace() + ", address=" + this.getAddress() + ", subTitle=" + this.getSubTitle() + ", info=" + this.getInfo() + ")";
    }

    @ConstructorProperties(value={"startTime", "endTime", "arrivalTime", "place", "address", "subTitle", "info"})
    public Appointment(ZonedDateTime startTime, ZonedDateTime endTime, String arrivalTime, String place, Address address, String subTitle, List<Info> info) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.arrivalTime = arrivalTime;
        this.place = place;
        this.address = address;
        this.subTitle = subTitle;
        this.info = info;
    }

    private Appointment() {
        this.startTime = null;
        this.endTime = null;
        this.arrivalTime = null;
        this.place = null;
        this.address = null;
        this.subTitle = null;
        this.info = null;
    }

    public Appointment withStartTime(ZonedDateTime startTime) {
        return this.startTime == startTime ? this : new Appointment(startTime, this.endTime, this.arrivalTime, this.place, this.address, this.subTitle, this.info);
    }

    public Appointment withEndTime(ZonedDateTime endTime) {
        return this.endTime == endTime ? this : new Appointment(this.startTime, endTime, this.arrivalTime, this.place, this.address, this.subTitle, this.info);
    }

    public Appointment withArrivalTime(String arrivalTime) {
        return this.arrivalTime == arrivalTime ? this : new Appointment(this.startTime, this.endTime, arrivalTime, this.place, this.address, this.subTitle, this.info);
    }

    public Appointment withPlace(String place) {
        return this.place == place ? this : new Appointment(this.startTime, this.endTime, this.arrivalTime, place, this.address, this.subTitle, this.info);
    }

    public Appointment withAddress(Address address) {
        return this.address == address ? this : new Appointment(this.startTime, this.endTime, this.arrivalTime, this.place, address, this.subTitle, this.info);
    }

    public Appointment withSubTitle(String subTitle) {
        return this.subTitle == subTitle ? this : new Appointment(this.startTime, this.endTime, this.arrivalTime, this.place, this.address, subTitle, this.info);
    }

    public Appointment withInfo(List<Info> info) {
        return this.info == info ? this : new Appointment(this.startTime, this.endTime, this.arrivalTime, this.place, this.address, this.subTitle, info);
    }
}

