/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class Barcode {
    public static final String CODE_128 = "code-128";
    @XmlElement(name="barcode-value")
    @Description(value="The barcode on this receipt")
    @Size(max=20)
    private final @Size(max=20) String barcodeValue;
    @XmlElement(name="barcode-type")
    @Size(max=12)
    private final @Size(max=12) String barcodeType;
    @XmlElement(name="barcode-text")
    @Description(value="Barcode text can be used to describe the barcode")
    private final String barcodeText;
    @XmlElement(name="show-value-in-barcode", defaultValue="false")
    @Description(value="If true, the barcode will render its value as part of the image")
    private final Boolean showValueInBarcode;
    public static Barcode EXAMPLE = new Barcode("1234567890", "code-128", "Show barcode for faster identification", true);

    public Barcode(@Size(max=20) @Size(max=20) String barcodeValue, @Size(max=12) @Size(max=12) String barcodeType) {
        this.barcodeValue = barcodeValue;
        this.barcodeType = barcodeType;
        this.barcodeText = null;
        this.showValueInBarcode = false;
    }

    public String getBarcodeValue() {
        return this.barcodeValue;
    }

    public String getBarcodeType() {
        return this.barcodeType;
    }

    public String getBarcodeText() {
        return this.barcodeText;
    }

    public Boolean getShowValueInBarcode() {
        return this.showValueInBarcode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Barcode)) {
            return false;
        }
        Barcode other = (Barcode)o;
        String this$barcodeValue = this.getBarcodeValue();
        String other$barcodeValue = other.getBarcodeValue();
        if (this$barcodeValue == null ? other$barcodeValue != null : !this$barcodeValue.equals(other$barcodeValue)) {
            return false;
        }
        String this$barcodeType = this.getBarcodeType();
        String other$barcodeType = other.getBarcodeType();
        if (this$barcodeType == null ? other$barcodeType != null : !this$barcodeType.equals(other$barcodeType)) {
            return false;
        }
        String this$barcodeText = this.getBarcodeText();
        String other$barcodeText = other.getBarcodeText();
        if (this$barcodeText == null ? other$barcodeText != null : !this$barcodeText.equals(other$barcodeText)) {
            return false;
        }
        Boolean this$showValueInBarcode = this.getShowValueInBarcode();
        Boolean other$showValueInBarcode = other.getShowValueInBarcode();
        return !(this$showValueInBarcode == null ? other$showValueInBarcode != null : !((Object)this$showValueInBarcode).equals(other$showValueInBarcode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $barcodeValue = this.getBarcodeValue();
        result = result * 59 + ($barcodeValue == null ? 43 : $barcodeValue.hashCode());
        String $barcodeType = this.getBarcodeType();
        result = result * 59 + ($barcodeType == null ? 43 : $barcodeType.hashCode());
        String $barcodeText = this.getBarcodeText();
        result = result * 59 + ($barcodeText == null ? 43 : $barcodeText.hashCode());
        Boolean $showValueInBarcode = this.getShowValueInBarcode();
        result = result * 59 + ($showValueInBarcode == null ? 43 : ((Object)$showValueInBarcode).hashCode());
        return result;
    }

    public String toString() {
        return "Barcode(barcodeValue=" + this.getBarcodeValue() + ", barcodeType=" + this.getBarcodeType() + ", barcodeText=" + this.getBarcodeText() + ", showValueInBarcode=" + this.getShowValueInBarcode() + ")";
    }

    @ConstructorProperties(value={"barcodeValue", "barcodeType", "barcodeText", "showValueInBarcode"})
    public Barcode(String barcodeValue, String barcodeType, String barcodeText, Boolean showValueInBarcode) {
        this.barcodeValue = barcodeValue;
        this.barcodeType = barcodeType;
        this.barcodeText = barcodeText;
        this.showValueInBarcode = showValueInBarcode;
    }

    private Barcode() {
        this.barcodeValue = null;
        this.barcodeType = null;
        this.barcodeText = null;
        this.showValueInBarcode = null;
    }

    public Barcode withBarcodeValue(String barcodeValue) {
        return this.barcodeValue == barcodeValue ? this : new Barcode(barcodeValue, this.barcodeType, this.barcodeText, this.showValueInBarcode);
    }

    public Barcode withBarcodeType(String barcodeType) {
        return this.barcodeType == barcodeType ? this : new Barcode(this.barcodeValue, barcodeType, this.barcodeText, this.showValueInBarcode);
    }

    public Barcode withBarcodeText(String barcodeText) {
        return this.barcodeText == barcodeText ? this : new Barcode(this.barcodeValue, this.barcodeType, barcodeText, this.showValueInBarcode);
    }

    public Barcode withShowValueInBarcode(Boolean showValueInBarcode) {
        return this.showValueInBarcode == showValueInBarcode ? this : new Barcode(this.barcodeValue, this.barcodeType, this.barcodeText, showValueInBarcode);
    }
}

