/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.ComplementedBy;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.ExternalLink;
import no.digipost.api.datatypes.types.Heftelse;
import no.digipost.api.datatypes.types.Hjemmelshaver;
import no.digipost.api.datatypes.types.Omsetningshistorikk;
import no.digipost.api.datatypes.types.Residence;

@XmlRootElement
@Description(value="Details about a Residence, and may be joined with Residence to retrieve the core fields of a Residence.")
@ComplementedBy(value={Boligdetaljer.class})
public final class Boligdetaljer
implements DataType {
    @XmlElement
    @NotNull
    @Valid
    private final Residence residence;
    @XmlElement
    @Description(value="List of people with legal rights associated with the residence")
    @Valid
    private final List<Hjemmelshaver> hjemmelshavere;
    @XmlElement
    @Min(value=0L, message="The value must be positive")
    @Description(value="BRA for bolig")
    private final @Min(value=0L, message="The value must be positive") Integer bruksareal;
    @XmlElement(name="antall-oppholdsrom")
    @Min(value=0L, message="The value must be positive")
    @Description(value="Number of rooms, bathroom, kitchen and storage rooms excluded")
    private final @Min(value=0L, message="The value must be positive") Integer antallOppholdsrom;
    @XmlElement(name="antall-baderom")
    @Min(value=0L, message="The value must be positive")
    @Description(value="Number of bathrooms")
    private final @Min(value=0L, message="The value must be positive") Integer antallBaderom;
    @XmlElement(name="omsetningshistorikk")
    @Description(value="Previous sales and transactions")
    @Valid
    private final List<Omsetningshistorikk> omsetningshistorikk;
    @XmlElement
    @Size(max=20)
    private final @Size(max=20) String organisasjonsnummer;
    @XmlElement
    @Size(max=10)
    private final @Size(max=10) String bruksenhet;
    @XmlElement
    private final String andelsnummer;
    @XmlElement
    @Valid
    private final List<Heftelse> heftelser;
    @XmlElement
    @Valid
    @Description(value="An optional ExternalLink prompting the user to perform an action on an external site")
    private final ExternalLink callToAction;
    public static Boligdetaljer EXAMPLE = new Boligdetaljer(Residence.EXAMPLE, Collections.singletonList(new Hjemmelshaver("Gunnar Gunnersen", "gunnargunnar@gunn.ar")), 59, 3, 4, Collections.singletonList(new Omsetningshistorikk(ZonedDateTime.of(2017, 7, 27, 10, 0, 0, 0, ZoneId.systemDefault()), "Privat salg av sekund\u00e6rbolig", "Bill Isalg", "Cooper Coopersen", 12345678L)), "123456789", "H1337", "42", Collections.singletonList(new Heftelse("TNT ASA", "Pantedokument", "3000000000")), ExternalLink.EXAMPLE_NO_DEADLINE);

    public Boligdetaljer(Residence residence, List<Hjemmelshaver> hjemmelshavere, Integer bruksareal, Integer antallOppholdsrom, Integer antallBaderom, List<Omsetningshistorikk> omsetningshistorikk, String organisasjonsnummer, String bruksenhet, String andelsnummer, List<Heftelse> heftelser) {
        this(residence, hjemmelshavere, bruksareal, antallOppholdsrom, antallBaderom, omsetningshistorikk, organisasjonsnummer, bruksenhet, andelsnummer, heftelser, null);
    }

    public Residence getResidence() {
        return this.residence;
    }

    public List<Hjemmelshaver> getHjemmelshavere() {
        return this.hjemmelshavere;
    }

    public Integer getBruksareal() {
        return this.bruksareal;
    }

    public Integer getAntallOppholdsrom() {
        return this.antallOppholdsrom;
    }

    public Integer getAntallBaderom() {
        return this.antallBaderom;
    }

    public List<Omsetningshistorikk> getOmsetningshistorikk() {
        return this.omsetningshistorikk;
    }

    public String getOrganisasjonsnummer() {
        return this.organisasjonsnummer;
    }

    public String getBruksenhet() {
        return this.bruksenhet;
    }

    public String getAndelsnummer() {
        return this.andelsnummer;
    }

    public List<Heftelse> getHeftelser() {
        return this.heftelser;
    }

    public ExternalLink getCallToAction() {
        return this.callToAction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Boligdetaljer)) {
            return false;
        }
        Boligdetaljer other = (Boligdetaljer)o;
        Residence this$residence = this.getResidence();
        Residence other$residence = other.getResidence();
        if (this$residence == null ? other$residence != null : !((Object)this$residence).equals(other$residence)) {
            return false;
        }
        List<Hjemmelshaver> this$hjemmelshavere = this.getHjemmelshavere();
        List<Hjemmelshaver> other$hjemmelshavere = other.getHjemmelshavere();
        if (this$hjemmelshavere == null ? other$hjemmelshavere != null : !((Object)this$hjemmelshavere).equals(other$hjemmelshavere)) {
            return false;
        }
        Integer this$bruksareal = this.getBruksareal();
        Integer other$bruksareal = other.getBruksareal();
        if (this$bruksareal == null ? other$bruksareal != null : !((Object)this$bruksareal).equals(other$bruksareal)) {
            return false;
        }
        Integer this$antallOppholdsrom = this.getAntallOppholdsrom();
        Integer other$antallOppholdsrom = other.getAntallOppholdsrom();
        if (this$antallOppholdsrom == null ? other$antallOppholdsrom != null : !((Object)this$antallOppholdsrom).equals(other$antallOppholdsrom)) {
            return false;
        }
        Integer this$antallBaderom = this.getAntallBaderom();
        Integer other$antallBaderom = other.getAntallBaderom();
        if (this$antallBaderom == null ? other$antallBaderom != null : !((Object)this$antallBaderom).equals(other$antallBaderom)) {
            return false;
        }
        List<Omsetningshistorikk> this$omsetningshistorikk = this.getOmsetningshistorikk();
        List<Omsetningshistorikk> other$omsetningshistorikk = other.getOmsetningshistorikk();
        if (this$omsetningshistorikk == null ? other$omsetningshistorikk != null : !((Object)this$omsetningshistorikk).equals(other$omsetningshistorikk)) {
            return false;
        }
        String this$organisasjonsnummer = this.getOrganisasjonsnummer();
        String other$organisasjonsnummer = other.getOrganisasjonsnummer();
        if (this$organisasjonsnummer == null ? other$organisasjonsnummer != null : !this$organisasjonsnummer.equals(other$organisasjonsnummer)) {
            return false;
        }
        String this$bruksenhet = this.getBruksenhet();
        String other$bruksenhet = other.getBruksenhet();
        if (this$bruksenhet == null ? other$bruksenhet != null : !this$bruksenhet.equals(other$bruksenhet)) {
            return false;
        }
        String this$andelsnummer = this.getAndelsnummer();
        String other$andelsnummer = other.getAndelsnummer();
        if (this$andelsnummer == null ? other$andelsnummer != null : !this$andelsnummer.equals(other$andelsnummer)) {
            return false;
        }
        List<Heftelse> this$heftelser = this.getHeftelser();
        List<Heftelse> other$heftelser = other.getHeftelser();
        if (this$heftelser == null ? other$heftelser != null : !((Object)this$heftelser).equals(other$heftelser)) {
            return false;
        }
        ExternalLink this$callToAction = this.getCallToAction();
        ExternalLink other$callToAction = other.getCallToAction();
        return !(this$callToAction == null ? other$callToAction != null : !((Object)this$callToAction).equals(other$callToAction));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Residence $residence = this.getResidence();
        result = result * 59 + ($residence == null ? 43 : ((Object)$residence).hashCode());
        List<Hjemmelshaver> $hjemmelshavere = this.getHjemmelshavere();
        result = result * 59 + ($hjemmelshavere == null ? 43 : ((Object)$hjemmelshavere).hashCode());
        Integer $bruksareal = this.getBruksareal();
        result = result * 59 + ($bruksareal == null ? 43 : ((Object)$bruksareal).hashCode());
        Integer $antallOppholdsrom = this.getAntallOppholdsrom();
        result = result * 59 + ($antallOppholdsrom == null ? 43 : ((Object)$antallOppholdsrom).hashCode());
        Integer $antallBaderom = this.getAntallBaderom();
        result = result * 59 + ($antallBaderom == null ? 43 : ((Object)$antallBaderom).hashCode());
        List<Omsetningshistorikk> $omsetningshistorikk = this.getOmsetningshistorikk();
        result = result * 59 + ($omsetningshistorikk == null ? 43 : ((Object)$omsetningshistorikk).hashCode());
        String $organisasjonsnummer = this.getOrganisasjonsnummer();
        result = result * 59 + ($organisasjonsnummer == null ? 43 : $organisasjonsnummer.hashCode());
        String $bruksenhet = this.getBruksenhet();
        result = result * 59 + ($bruksenhet == null ? 43 : $bruksenhet.hashCode());
        String $andelsnummer = this.getAndelsnummer();
        result = result * 59 + ($andelsnummer == null ? 43 : $andelsnummer.hashCode());
        List<Heftelse> $heftelser = this.getHeftelser();
        result = result * 59 + ($heftelser == null ? 43 : ((Object)$heftelser).hashCode());
        ExternalLink $callToAction = this.getCallToAction();
        result = result * 59 + ($callToAction == null ? 43 : ((Object)$callToAction).hashCode());
        return result;
    }

    public String toString() {
        return "Boligdetaljer(residence=" + this.getResidence() + ", hjemmelshavere=" + this.getHjemmelshavere() + ", bruksareal=" + this.getBruksareal() + ", antallOppholdsrom=" + this.getAntallOppholdsrom() + ", antallBaderom=" + this.getAntallBaderom() + ", omsetningshistorikk=" + this.getOmsetningshistorikk() + ", organisasjonsnummer=" + this.getOrganisasjonsnummer() + ", bruksenhet=" + this.getBruksenhet() + ", andelsnummer=" + this.getAndelsnummer() + ", heftelser=" + this.getHeftelser() + ", callToAction=" + this.getCallToAction() + ")";
    }

    @ConstructorProperties(value={"residence", "hjemmelshavere", "bruksareal", "antallOppholdsrom", "antallBaderom", "omsetningshistorikk", "organisasjonsnummer", "bruksenhet", "andelsnummer", "heftelser", "callToAction"})
    public Boligdetaljer(Residence residence, List<Hjemmelshaver> hjemmelshavere, Integer bruksareal, Integer antallOppholdsrom, Integer antallBaderom, List<Omsetningshistorikk> omsetningshistorikk, String organisasjonsnummer, String bruksenhet, String andelsnummer, List<Heftelse> heftelser, ExternalLink callToAction) {
        this.residence = residence;
        this.hjemmelshavere = hjemmelshavere;
        this.bruksareal = bruksareal;
        this.antallOppholdsrom = antallOppholdsrom;
        this.antallBaderom = antallBaderom;
        this.omsetningshistorikk = omsetningshistorikk;
        this.organisasjonsnummer = organisasjonsnummer;
        this.bruksenhet = bruksenhet;
        this.andelsnummer = andelsnummer;
        this.heftelser = heftelser;
        this.callToAction = callToAction;
    }

    private Boligdetaljer() {
        this.residence = null;
        this.hjemmelshavere = null;
        this.bruksareal = null;
        this.antallOppholdsrom = null;
        this.antallBaderom = null;
        this.omsetningshistorikk = null;
        this.organisasjonsnummer = null;
        this.bruksenhet = null;
        this.andelsnummer = null;
        this.heftelser = null;
        this.callToAction = null;
    }

    public Boligdetaljer withResidence(Residence residence) {
        return this.residence == residence ? this : new Boligdetaljer(residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withHjemmelshavere(List<Hjemmelshaver> hjemmelshavere) {
        return this.hjemmelshavere == hjemmelshavere ? this : new Boligdetaljer(this.residence, hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withBruksareal(Integer bruksareal) {
        return this.bruksareal == bruksareal ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withAntallOppholdsrom(Integer antallOppholdsrom) {
        return this.antallOppholdsrom == antallOppholdsrom ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withAntallBaderom(Integer antallBaderom) {
        return this.antallBaderom == antallBaderom ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withOmsetningshistorikk(List<Omsetningshistorikk> omsetningshistorikk) {
        return this.omsetningshistorikk == omsetningshistorikk ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withOrganisasjonsnummer(String organisasjonsnummer) {
        return this.organisasjonsnummer == organisasjonsnummer ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withBruksenhet(String bruksenhet) {
        return this.bruksenhet == bruksenhet ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, bruksenhet, this.andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withAndelsnummer(String andelsnummer) {
        return this.andelsnummer == andelsnummer ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, andelsnummer, this.heftelser, this.callToAction);
    }

    public Boligdetaljer withHeftelser(List<Heftelse> heftelser) {
        return this.heftelser == heftelser ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, heftelser, this.callToAction);
    }

    public Boligdetaljer withCallToAction(ExternalLink callToAction) {
        return this.callToAction == callToAction ? this : new Boligdetaljer(this.residence, this.hjemmelshavere, this.bruksareal, this.antallOppholdsrom, this.antallBaderom, this.omsetningshistorikk, this.organisasjonsnummer, this.bruksenhet, this.andelsnummer, this.heftelser, callToAction);
    }
}

