/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;
import no.digipost.api.datatypes.types.Barcode;
import no.digipost.api.datatypes.types.Info;
import no.digipost.api.datatypes.types.Link;
import no.digipost.api.datatypes.types.TimeInterval;

@XmlRootElement
@Description(value="Event represents an event that occurs over a time period or several days. Eg. a conference or an election")
public final class Event
implements DataType {
    @XmlElement(name="sub-title")
    @Size(max=100)
    @Description(value="Example: 'Kommunestyre- og fylkestingvalg'")
    private final @Size(max=100) String subTitle;
    @XmlElement(name="start-time", required=true)
    @NotEmpty
    @Description(value="List of time intervals")
    private final List<TimeInterval> time;
    @XmlElement
    @Description(value="Optional label for time. null yield default in gui, eg. 'Opening hours'")
    @Size(max=100)
    private final @Size(max=100) String timeLabel;
    @XmlElement(name="description")
    @Description(value="Free text but can contain a ISO8601 DateTime. Example: 'Please use entrance from street'")
    @Size(max=120)
    private final @Size(max=120) String description;
    @XmlElement
    @Description(value="The name of the place. Example: 'Sagene skole'")
    private final String place;
    @XmlElement
    @Description(value="Optional label for place. null yield default in gui, eg. 'Venue location'")
    @Size(max=100)
    private final @Size(max=100) String placeLabel;
    @XmlElement
    @Valid
    private final Address address;
    @XmlElement
    @Valid
    @Size(max=10)
    @Description(value="Additional sections of information (max 10) with a title and text.")
    private final @Valid @Size(max=10) List<Info> info;
    @XmlElement
    @Description(value="Optional label for barcode. null yield default in gui, eg. ''")
    @Size(max=100)
    private final @Size(max=100) String barcodeLabel;
    @XmlElement(name="barcode")
    @Description(value="Barcode")
    private final Barcode barcode;
    @XmlElement(name="links")
    @Description(value="Links for releated information to the appointment")
    private final List<Link> links;
    public static Event EXAMPLE = new Event("Kommunestyre- og fylkestingvalg", Collections.singletonList(TimeInterval.EXAMPLE), "Opening hours", "Velkommen til valg! Husk legitimasjon.", "Sagene skole", "Election venue", Address.EXAMPLE, Collections.singletonList(new Info("Forh\u00e5ndsstemming", "Du kan forh\u00e5ndsstemme fra 10. august")), "Barcode for use on election day:", Barcode.EXAMPLE, Collections.singletonList(Link.EXAMPLE));

    public String getSubTitle() {
        return this.subTitle;
    }

    public List<TimeInterval> getTime() {
        return this.time;
    }

    public String getTimeLabel() {
        return this.timeLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPlace() {
        return this.place;
    }

    public String getPlaceLabel() {
        return this.placeLabel;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<Info> getInfo() {
        return this.info;
    }

    public String getBarcodeLabel() {
        return this.barcodeLabel;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        List<TimeInterval> this$time = this.getTime();
        List<TimeInterval> other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$timeLabel = this.getTimeLabel();
        String other$timeLabel = other.getTimeLabel();
        if (this$timeLabel == null ? other$timeLabel != null : !this$timeLabel.equals(other$timeLabel)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        String this$placeLabel = this.getPlaceLabel();
        String other$placeLabel = other.getPlaceLabel();
        if (this$placeLabel == null ? other$placeLabel != null : !this$placeLabel.equals(other$placeLabel)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        List<Info> this$info = this.getInfo();
        List<Info> other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        String this$barcodeLabel = this.getBarcodeLabel();
        String other$barcodeLabel = other.getBarcodeLabel();
        if (this$barcodeLabel == null ? other$barcodeLabel != null : !this$barcodeLabel.equals(other$barcodeLabel)) {
            return false;
        }
        Barcode this$barcode = this.getBarcode();
        Barcode other$barcode = other.getBarcode();
        if (this$barcode == null ? other$barcode != null : !((Object)this$barcode).equals(other$barcode)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        List<TimeInterval> $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $timeLabel = this.getTimeLabel();
        result = result * 59 + ($timeLabel == null ? 43 : $timeLabel.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        String $placeLabel = this.getPlaceLabel();
        result = result * 59 + ($placeLabel == null ? 43 : $placeLabel.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        List<Info> $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        String $barcodeLabel = this.getBarcodeLabel();
        result = result * 59 + ($barcodeLabel == null ? 43 : $barcodeLabel.hashCode());
        Barcode $barcode = this.getBarcode();
        result = result * 59 + ($barcode == null ? 43 : ((Object)$barcode).hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public String toString() {
        return "Event(subTitle=" + this.getSubTitle() + ", time=" + this.getTime() + ", timeLabel=" + this.getTimeLabel() + ", description=" + this.getDescription() + ", place=" + this.getPlace() + ", placeLabel=" + this.getPlaceLabel() + ", address=" + this.getAddress() + ", info=" + this.getInfo() + ", barcodeLabel=" + this.getBarcodeLabel() + ", barcode=" + this.getBarcode() + ", links=" + this.getLinks() + ")";
    }

    @ConstructorProperties(value={"subTitle", "time", "timeLabel", "description", "place", "placeLabel", "address", "info", "barcodeLabel", "barcode", "links"})
    public Event(String subTitle, List<TimeInterval> time, String timeLabel, String description, String place, String placeLabel, Address address, List<Info> info, String barcodeLabel, Barcode barcode, List<Link> links) {
        this.subTitle = subTitle;
        this.time = time;
        this.timeLabel = timeLabel;
        this.description = description;
        this.place = place;
        this.placeLabel = placeLabel;
        this.address = address;
        this.info = info;
        this.barcodeLabel = barcodeLabel;
        this.barcode = barcode;
        this.links = links;
    }

    private Event() {
        this.subTitle = null;
        this.time = null;
        this.timeLabel = null;
        this.description = null;
        this.place = null;
        this.placeLabel = null;
        this.address = null;
        this.info = null;
        this.barcodeLabel = null;
        this.barcode = null;
        this.links = null;
    }

    public Event withSubTitle(String subTitle) {
        return this.subTitle == subTitle ? this : new Event(subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withTime(List<TimeInterval> time) {
        return this.time == time ? this : new Event(this.subTitle, time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withTimeLabel(String timeLabel) {
        return this.timeLabel == timeLabel ? this : new Event(this.subTitle, this.time, timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withDescription(String description) {
        return this.description == description ? this : new Event(this.subTitle, this.time, this.timeLabel, description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withPlace(String place) {
        return this.place == place ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withPlaceLabel(String placeLabel) {
        return this.placeLabel == placeLabel ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withAddress(Address address) {
        return this.address == address ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, address, this.info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withInfo(List<Info> info) {
        return this.info == info ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, info, this.barcodeLabel, this.barcode, this.links);
    }

    public Event withBarcodeLabel(String barcodeLabel) {
        return this.barcodeLabel == barcodeLabel ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, barcodeLabel, this.barcode, this.links);
    }

    public Event withBarcode(Barcode barcode) {
        return this.barcode == barcode ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, barcode, this.links);
    }

    public Event withLinks(List<Link> links) {
        return this.links == links ? this : new Event(this.subTitle, this.time, this.timeLabel, this.description, this.place, this.placeLabel, this.address, this.info, this.barcodeLabel, this.barcode, links);
    }
}

