/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
@Description(value="A previous transaction or sale")
public final class Omsetningshistorikk {
    @XmlElement(name="dato", required=true)
    @NotNull
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime dato;
    @XmlElement
    @Size(max=50)
    private final @Size(max=50) String beskrivelse;
    @XmlElement
    private final String selger;
    @XmlElement
    private final String kjoeper;
    @XmlElement
    private final Long beloep;

    public ZonedDateTime getDato() {
        return this.dato;
    }

    public String getBeskrivelse() {
        return this.beskrivelse;
    }

    public String getSelger() {
        return this.selger;
    }

    public String getKjoeper() {
        return this.kjoeper;
    }

    public Long getBeloep() {
        return this.beloep;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Omsetningshistorikk)) {
            return false;
        }
        Omsetningshistorikk other = (Omsetningshistorikk)o;
        ZonedDateTime this$dato = this.getDato();
        ZonedDateTime other$dato = other.getDato();
        if (this$dato == null ? other$dato != null : !((Object)this$dato).equals(other$dato)) {
            return false;
        }
        String this$beskrivelse = this.getBeskrivelse();
        String other$beskrivelse = other.getBeskrivelse();
        if (this$beskrivelse == null ? other$beskrivelse != null : !this$beskrivelse.equals(other$beskrivelse)) {
            return false;
        }
        String this$selger = this.getSelger();
        String other$selger = other.getSelger();
        if (this$selger == null ? other$selger != null : !this$selger.equals(other$selger)) {
            return false;
        }
        String this$kjoeper = this.getKjoeper();
        String other$kjoeper = other.getKjoeper();
        if (this$kjoeper == null ? other$kjoeper != null : !this$kjoeper.equals(other$kjoeper)) {
            return false;
        }
        Long this$beloep = this.getBeloep();
        Long other$beloep = other.getBeloep();
        return !(this$beloep == null ? other$beloep != null : !((Object)this$beloep).equals(other$beloep));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $dato = this.getDato();
        result = result * 59 + ($dato == null ? 43 : ((Object)$dato).hashCode());
        String $beskrivelse = this.getBeskrivelse();
        result = result * 59 + ($beskrivelse == null ? 43 : $beskrivelse.hashCode());
        String $selger = this.getSelger();
        result = result * 59 + ($selger == null ? 43 : $selger.hashCode());
        String $kjoeper = this.getKjoeper();
        result = result * 59 + ($kjoeper == null ? 43 : $kjoeper.hashCode());
        Long $beloep = this.getBeloep();
        result = result * 59 + ($beloep == null ? 43 : ((Object)$beloep).hashCode());
        return result;
    }

    public String toString() {
        return "Omsetningshistorikk(dato=" + this.getDato() + ", beskrivelse=" + this.getBeskrivelse() + ", selger=" + this.getSelger() + ", kjoeper=" + this.getKjoeper() + ", beloep=" + this.getBeloep() + ")";
    }

    @ConstructorProperties(value={"dato", "beskrivelse", "selger", "kjoeper", "beloep"})
    public Omsetningshistorikk(ZonedDateTime dato, String beskrivelse, String selger, String kjoeper, Long beloep) {
        this.dato = dato;
        this.beskrivelse = beskrivelse;
        this.selger = selger;
        this.kjoeper = kjoeper;
        this.beloep = beloep;
    }

    private Omsetningshistorikk() {
        this.dato = null;
        this.beskrivelse = null;
        this.selger = null;
        this.kjoeper = null;
        this.beloep = null;
    }

    public Omsetningshistorikk withDato(ZonedDateTime dato) {
        return this.dato == dato ? this : new Omsetningshistorikk(dato, this.beskrivelse, this.selger, this.kjoeper, this.beloep);
    }

    public Omsetningshistorikk withBeskrivelse(String beskrivelse) {
        return this.beskrivelse == beskrivelse ? this : new Omsetningshistorikk(this.dato, beskrivelse, this.selger, this.kjoeper, this.beloep);
    }

    public Omsetningshistorikk withSelger(String selger) {
        return this.selger == selger ? this : new Omsetningshistorikk(this.dato, this.beskrivelse, selger, this.kjoeper, this.beloep);
    }

    public Omsetningshistorikk withKjoeper(String kjoeper) {
        return this.kjoeper == kjoeper ? this : new Omsetningshistorikk(this.dato, this.beskrivelse, this.selger, kjoeper, this.beloep);
    }

    public Omsetningshistorikk withBeloep(Long beloep) {
        return this.beloep == beloep ? this : new Omsetningshistorikk(this.dato, this.beskrivelse, this.selger, this.kjoeper, beloep);
    }
}

