/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class ResidenceAddress {
    @XmlElement(name="unit-number")
    @Size(max=5)
    @Pattern(regexp="^[UKHL]\\d{4}$", message="must be of format [UKHL]0000. E.g. H0304")
    @Description(value="Bolignummer. Must be of format [UKHL]0000. E.g. H0304")
    private final @Size(max=5) @Pattern(regexp="^[UKHL]\\d{4}$", message="must be of format [UKHL]0000. E.g. H0304") String unitNumber;
    @XmlElement(name="house-number")
    @Size(max=5)
    @Description(value="A house number with or without a house letter. E.g. 11 or 11A")
    private final @Size(max=5) String houseNumber;
    @XmlElement(name="street-name")
    @Size(max=100)
    @Description(value="The name of the street. E.g. Storgata")
    private final @Size(max=100) String streetName;
    @XmlElement(name="postal-code")
    @Size(max=10)
    private final @Size(max=10) String postalCode;
    @XmlElement
    @Size(max=100)
    private final @Size(max=100) String city;
    public static final ResidenceAddress EXAMPLE = new ResidenceAddress("23", "Storgata", "0011", "Oslo");

    public ResidenceAddress(String houseNumber, String streetName, String postalCode, String city) {
        this(null, houseNumber, streetName, postalCode, city);
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResidenceAddress)) {
            return false;
        }
        ResidenceAddress other = (ResidenceAddress)o;
        String this$unitNumber = this.getUnitNumber();
        String other$unitNumber = other.getUnitNumber();
        if (this$unitNumber == null ? other$unitNumber != null : !this$unitNumber.equals(other$unitNumber)) {
            return false;
        }
        String this$houseNumber = this.getHouseNumber();
        String other$houseNumber = other.getHouseNumber();
        if (this$houseNumber == null ? other$houseNumber != null : !this$houseNumber.equals(other$houseNumber)) {
            return false;
        }
        String this$streetName = this.getStreetName();
        String other$streetName = other.getStreetName();
        if (this$streetName == null ? other$streetName != null : !this$streetName.equals(other$streetName)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        return !(this$city == null ? other$city != null : !this$city.equals(other$city));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $unitNumber = this.getUnitNumber();
        result = result * 59 + ($unitNumber == null ? 43 : $unitNumber.hashCode());
        String $houseNumber = this.getHouseNumber();
        result = result * 59 + ($houseNumber == null ? 43 : $houseNumber.hashCode());
        String $streetName = this.getStreetName();
        result = result * 59 + ($streetName == null ? 43 : $streetName.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        return result;
    }

    public String toString() {
        return "ResidenceAddress(unitNumber=" + this.getUnitNumber() + ", houseNumber=" + this.getHouseNumber() + ", streetName=" + this.getStreetName() + ", postalCode=" + this.getPostalCode() + ", city=" + this.getCity() + ")";
    }

    @ConstructorProperties(value={"unitNumber", "houseNumber", "streetName", "postalCode", "city"})
    public ResidenceAddress(String unitNumber, String houseNumber, String streetName, String postalCode, String city) {
        this.unitNumber = unitNumber;
        this.houseNumber = houseNumber;
        this.streetName = streetName;
        this.postalCode = postalCode;
        this.city = city;
    }

    private ResidenceAddress() {
        this.unitNumber = null;
        this.houseNumber = null;
        this.streetName = null;
        this.postalCode = null;
        this.city = null;
    }

    public ResidenceAddress withUnitNumber(String unitNumber) {
        return this.unitNumber == unitNumber ? this : new ResidenceAddress(unitNumber, this.houseNumber, this.streetName, this.postalCode, this.city);
    }

    public ResidenceAddress withHouseNumber(String houseNumber) {
        return this.houseNumber == houseNumber ? this : new ResidenceAddress(this.unitNumber, houseNumber, this.streetName, this.postalCode, this.city);
    }

    public ResidenceAddress withStreetName(String streetName) {
        return this.streetName == streetName ? this : new ResidenceAddress(this.unitNumber, this.houseNumber, streetName, this.postalCode, this.city);
    }

    public ResidenceAddress withPostalCode(String postalCode) {
        return this.postalCode == postalCode ? this : new ResidenceAddress(this.unitNumber, this.houseNumber, this.streetName, postalCode, this.city);
    }

    public ResidenceAddress withCity(String city) {
        return this.city == city ? this : new ResidenceAddress(this.unitNumber, this.houseNumber, this.streetName, this.postalCode, city);
    }
}

