/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;

@XmlRootElement
@Description(value="Details about a signed document")
public final class SignedDocument
implements DataType {
    @XmlElement(name="document-issuer", required=true)
    @Description(value="The original issuer of the document to be signed.")
    private final String documentIssuer;
    @XmlElement(name="document-subject", required=true)
    @Description(value="The original subject of the document to be signed.")
    private final String documentSubject;
    @XmlElement(name="signing-time", required=true)
    @Description(value="When the recipient signed the document. ISO8601 full DateTime.")
    @NotNull
    private final ZonedDateTime signingTime;
    public static SignedDocument EXAMPLE = new SignedDocument("Bedrift AS", "Ansettelseskontrakt", ZonedDateTime.of(2018, 7, 11, 10, 0, 0, 0, ZoneId.systemDefault()));

    public String getDocumentIssuer() {
        return this.documentIssuer;
    }

    public String getDocumentSubject() {
        return this.documentSubject;
    }

    public ZonedDateTime getSigningTime() {
        return this.signingTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedDocument)) {
            return false;
        }
        SignedDocument other = (SignedDocument)o;
        String this$documentIssuer = this.getDocumentIssuer();
        String other$documentIssuer = other.getDocumentIssuer();
        if (this$documentIssuer == null ? other$documentIssuer != null : !this$documentIssuer.equals(other$documentIssuer)) {
            return false;
        }
        String this$documentSubject = this.getDocumentSubject();
        String other$documentSubject = other.getDocumentSubject();
        if (this$documentSubject == null ? other$documentSubject != null : !this$documentSubject.equals(other$documentSubject)) {
            return false;
        }
        ZonedDateTime this$signingTime = this.getSigningTime();
        ZonedDateTime other$signingTime = other.getSigningTime();
        return !(this$signingTime == null ? other$signingTime != null : !((Object)this$signingTime).equals(other$signingTime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $documentIssuer = this.getDocumentIssuer();
        result = result * 59 + ($documentIssuer == null ? 43 : $documentIssuer.hashCode());
        String $documentSubject = this.getDocumentSubject();
        result = result * 59 + ($documentSubject == null ? 43 : $documentSubject.hashCode());
        ZonedDateTime $signingTime = this.getSigningTime();
        result = result * 59 + ($signingTime == null ? 43 : ((Object)$signingTime).hashCode());
        return result;
    }

    public String toString() {
        return "SignedDocument(documentIssuer=" + this.getDocumentIssuer() + ", documentSubject=" + this.getDocumentSubject() + ", signingTime=" + this.getSigningTime() + ")";
    }

    @ConstructorProperties(value={"documentIssuer", "documentSubject", "signingTime"})
    public SignedDocument(String documentIssuer, String documentSubject, ZonedDateTime signingTime) {
        this.documentIssuer = documentIssuer;
        this.documentSubject = documentSubject;
        this.signingTime = signingTime;
    }

    private SignedDocument() {
        this.documentIssuer = null;
        this.documentSubject = null;
        this.signingTime = null;
    }

    public SignedDocument withDocumentIssuer(String documentIssuer) {
        return this.documentIssuer == documentIssuer ? this : new SignedDocument(documentIssuer, this.documentSubject, this.signingTime);
    }

    public SignedDocument withDocumentSubject(String documentSubject) {
        return this.documentSubject == documentSubject ? this : new SignedDocument(this.documentIssuer, documentSubject, this.signingTime);
    }

    public SignedDocument withSigningTime(ZonedDateTime signingTime) {
        return this.signingTime == signingTime ? this : new SignedDocument(this.documentIssuer, this.documentSubject, signingTime);
    }
}

