/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.pickup;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class Cost {
    @XmlElement(name="value-to-be-payed", required=true)
    @Description(value="The value of the parcel in NOK")
    private final BigDecimal valueToBePayed;
    @XmlElement(name="package-value")
    @Description(value="The value of the parcel in NOK")
    private final BigDecimal packageValue;
    @XmlElement(name="customs-fee-outlayed")
    @Description(value="payed fee in customs")
    private final BigDecimal customsFeeOutlayed;
    @XmlElement(name="vas-text")
    @Description(value="Information about the value added service (vas)")
    private final String vasText;
    @XmlElement(name="customs-fee")
    @Description(value="Fee payed for customs declaration")
    private final BigDecimal customsFee;
    @XmlElement(name="customs-fee-outlay-cost")
    @Description(value="Outlay for customs by the service")
    private final BigDecimal customsFeeOutlayCost;
    @XmlElement(name="cod-amount")
    @Description(value="Cash on delivery (cod) amount")
    private final BigDecimal codAmount;
    @XmlElement(name="cod-fee")
    @Description(value="Cash on delivery (cod) fee")
    private final BigDecimal codFee;
    public static final Cost EXAMPLE = new Cost(new BigDecimal("128.00"), new BigDecimal("1277.00"), new BigDecimal("162.00"), "FORENKLET TOLLBEHANDLING", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);

    public BigDecimal getValueToBePayed() {
        return this.valueToBePayed;
    }

    public BigDecimal getPackageValue() {
        return this.packageValue;
    }

    public BigDecimal getCustomsFeeOutlayed() {
        return this.customsFeeOutlayed;
    }

    public String getVasText() {
        return this.vasText;
    }

    public BigDecimal getCustomsFee() {
        return this.customsFee;
    }

    public BigDecimal getCustomsFeeOutlayCost() {
        return this.customsFeeOutlayCost;
    }

    public BigDecimal getCodAmount() {
        return this.codAmount;
    }

    public BigDecimal getCodFee() {
        return this.codFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cost)) {
            return false;
        }
        Cost other = (Cost)o;
        BigDecimal this$valueToBePayed = this.getValueToBePayed();
        BigDecimal other$valueToBePayed = other.getValueToBePayed();
        if (this$valueToBePayed == null ? other$valueToBePayed != null : !((Object)this$valueToBePayed).equals(other$valueToBePayed)) {
            return false;
        }
        BigDecimal this$packageValue = this.getPackageValue();
        BigDecimal other$packageValue = other.getPackageValue();
        if (this$packageValue == null ? other$packageValue != null : !((Object)this$packageValue).equals(other$packageValue)) {
            return false;
        }
        BigDecimal this$customsFeeOutlayed = this.getCustomsFeeOutlayed();
        BigDecimal other$customsFeeOutlayed = other.getCustomsFeeOutlayed();
        if (this$customsFeeOutlayed == null ? other$customsFeeOutlayed != null : !((Object)this$customsFeeOutlayed).equals(other$customsFeeOutlayed)) {
            return false;
        }
        String this$vasText = this.getVasText();
        String other$vasText = other.getVasText();
        if (this$vasText == null ? other$vasText != null : !this$vasText.equals(other$vasText)) {
            return false;
        }
        BigDecimal this$customsFee = this.getCustomsFee();
        BigDecimal other$customsFee = other.getCustomsFee();
        if (this$customsFee == null ? other$customsFee != null : !((Object)this$customsFee).equals(other$customsFee)) {
            return false;
        }
        BigDecimal this$customsFeeOutlayCost = this.getCustomsFeeOutlayCost();
        BigDecimal other$customsFeeOutlayCost = other.getCustomsFeeOutlayCost();
        if (this$customsFeeOutlayCost == null ? other$customsFeeOutlayCost != null : !((Object)this$customsFeeOutlayCost).equals(other$customsFeeOutlayCost)) {
            return false;
        }
        BigDecimal this$codAmount = this.getCodAmount();
        BigDecimal other$codAmount = other.getCodAmount();
        if (this$codAmount == null ? other$codAmount != null : !((Object)this$codAmount).equals(other$codAmount)) {
            return false;
        }
        BigDecimal this$codFee = this.getCodFee();
        BigDecimal other$codFee = other.getCodFee();
        return !(this$codFee == null ? other$codFee != null : !((Object)this$codFee).equals(other$codFee));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $valueToBePayed = this.getValueToBePayed();
        result = result * 59 + ($valueToBePayed == null ? 43 : ((Object)$valueToBePayed).hashCode());
        BigDecimal $packageValue = this.getPackageValue();
        result = result * 59 + ($packageValue == null ? 43 : ((Object)$packageValue).hashCode());
        BigDecimal $customsFeeOutlayed = this.getCustomsFeeOutlayed();
        result = result * 59 + ($customsFeeOutlayed == null ? 43 : ((Object)$customsFeeOutlayed).hashCode());
        String $vasText = this.getVasText();
        result = result * 59 + ($vasText == null ? 43 : $vasText.hashCode());
        BigDecimal $customsFee = this.getCustomsFee();
        result = result * 59 + ($customsFee == null ? 43 : ((Object)$customsFee).hashCode());
        BigDecimal $customsFeeOutlayCost = this.getCustomsFeeOutlayCost();
        result = result * 59 + ($customsFeeOutlayCost == null ? 43 : ((Object)$customsFeeOutlayCost).hashCode());
        BigDecimal $codAmount = this.getCodAmount();
        result = result * 59 + ($codAmount == null ? 43 : ((Object)$codAmount).hashCode());
        BigDecimal $codFee = this.getCodFee();
        result = result * 59 + ($codFee == null ? 43 : ((Object)$codFee).hashCode());
        return result;
    }

    public String toString() {
        return "Cost(valueToBePayed=" + this.getValueToBePayed() + ", packageValue=" + this.getPackageValue() + ", customsFeeOutlayed=" + this.getCustomsFeeOutlayed() + ", vasText=" + this.getVasText() + ", customsFee=" + this.getCustomsFee() + ", customsFeeOutlayCost=" + this.getCustomsFeeOutlayCost() + ", codAmount=" + this.getCodAmount() + ", codFee=" + this.getCodFee() + ")";
    }

    @ConstructorProperties(value={"valueToBePayed", "packageValue", "customsFeeOutlayed", "vasText", "customsFee", "customsFeeOutlayCost", "codAmount", "codFee"})
    public Cost(BigDecimal valueToBePayed, BigDecimal packageValue, BigDecimal customsFeeOutlayed, String vasText, BigDecimal customsFee, BigDecimal customsFeeOutlayCost, BigDecimal codAmount, BigDecimal codFee) {
        this.valueToBePayed = valueToBePayed;
        this.packageValue = packageValue;
        this.customsFeeOutlayed = customsFeeOutlayed;
        this.vasText = vasText;
        this.customsFee = customsFee;
        this.customsFeeOutlayCost = customsFeeOutlayCost;
        this.codAmount = codAmount;
        this.codFee = codFee;
    }

    private Cost() {
        this.valueToBePayed = null;
        this.packageValue = null;
        this.customsFeeOutlayed = null;
        this.vasText = null;
        this.customsFee = null;
        this.customsFeeOutlayCost = null;
        this.codAmount = null;
        this.codFee = null;
    }

    public Cost withValueToBePayed(BigDecimal valueToBePayed) {
        return this.valueToBePayed == valueToBePayed ? this : new Cost(valueToBePayed, this.packageValue, this.customsFeeOutlayed, this.vasText, this.customsFee, this.customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withPackageValue(BigDecimal packageValue) {
        return this.packageValue == packageValue ? this : new Cost(this.valueToBePayed, packageValue, this.customsFeeOutlayed, this.vasText, this.customsFee, this.customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withCustomsFeeOutlayed(BigDecimal customsFeeOutlayed) {
        return this.customsFeeOutlayed == customsFeeOutlayed ? this : new Cost(this.valueToBePayed, this.packageValue, customsFeeOutlayed, this.vasText, this.customsFee, this.customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withVasText(String vasText) {
        return this.vasText == vasText ? this : new Cost(this.valueToBePayed, this.packageValue, this.customsFeeOutlayed, vasText, this.customsFee, this.customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withCustomsFee(BigDecimal customsFee) {
        return this.customsFee == customsFee ? this : new Cost(this.valueToBePayed, this.packageValue, this.customsFeeOutlayed, this.vasText, customsFee, this.customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withCustomsFeeOutlayCost(BigDecimal customsFeeOutlayCost) {
        return this.customsFeeOutlayCost == customsFeeOutlayCost ? this : new Cost(this.valueToBePayed, this.packageValue, this.customsFeeOutlayed, this.vasText, this.customsFee, customsFeeOutlayCost, this.codAmount, this.codFee);
    }

    public Cost withCodAmount(BigDecimal codAmount) {
        return this.codAmount == codAmount ? this : new Cost(this.valueToBePayed, this.packageValue, this.customsFeeOutlayed, this.vasText, this.customsFee, this.customsFeeOutlayCost, codAmount, this.codFee);
    }

    public Cost withCodFee(BigDecimal codFee) {
        return this.codFee == codFee ? this : new Cost(this.valueToBePayed, this.packageValue, this.customsFeeOutlayed, this.vasText, this.customsFee, this.customsFeeOutlayCost, this.codAmount, codFee);
    }
}

