/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.pickup;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.ComplementedBy;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Barcode;
import no.digipost.api.datatypes.types.Tag;
import no.digipost.api.datatypes.types.pickup.Cost;
import no.digipost.api.datatypes.types.pickup.Package;
import no.digipost.api.datatypes.types.pickup.PickupNoticeStatus;
import no.digipost.api.datatypes.types.pickup.PickupPlace;
import no.digipost.api.datatypes.types.pickup.Recipient;
import no.digipost.api.datatypes.types.pickup.Sender;
import no.digipost.api.datatypes.types.pickup.Status;

@XmlRootElement(name="pickup-notice")
@Description(value="Details about a pickup notice")
@ComplementedBy(value={PickupNotice.class, PickupNoticeStatus.class})
public final class PickupNotice
implements DataType {
    @XmlElement(name="parcel-id", required=true)
    @Description(value="The id of the parcel in posten")
    @NotNull
    @Valid
    private final String parcelId;
    @XmlElement(name="parcel-uuid")
    @Description(value="The uuid of the parcel")
    private final String parcelUUID;
    @XmlElement(name="barcode", required=true)
    @Description(value="Barcode")
    private final Barcode barcode;
    @XmlElement(name="product-name")
    @Description(value="Mail Service product name")
    private final String productName;
    @XmlElement(name="arrival-date-time", required=true)
    @Description(value="ISO8601 full DateTime for arrival at pickup place")
    @Valid
    private final ZonedDateTime arrivalDateTime;
    @XmlElement(name="return-date-time", required=true)
    @Description(value="ISO8601 full DateTime for return back to sender")
    @Valid
    private final ZonedDateTime returnDateTime;
    @XmlElement(name="recipient", required=true)
    @Description(value="The recipient of the parcel")
    @NotNull
    @Valid
    private final Recipient recipient;
    @XmlElement(name="sender")
    @Description(value="The sender of the parcel")
    @Valid
    private final Sender sender;
    @XmlElement(name="pickup-place", required=true)
    @Description(value="where the parcel can be fetched")
    @NotNull
    @Valid
    private final PickupPlace pickupPlace;
    @XmlElement(name="package")
    @Description(value="package information")
    private final Package thePackage;
    @XmlElement(name="cost")
    @Description(value="Information about value, mva, customs processing and more")
    private final Cost cost;
    @XmlElement(name="status")
    @Description(value="The state the package is at present time")
    private final Status status;
    @XmlElement(name="tags")
    @Description(value="Tags to describe the document")
    private final Set<Tag> tags;
    public static PickupNotice EXAMPLE = new PickupNotice("KB432788293NO", "70300492517312675", Barcode.EXAMPLE.withBarcodeType("CODE_128"), "Kliman\u00f8ytral Servicepakke", ZonedDateTime.of(2018, 9, 10, 10, 0, 0, 0, ZoneId.systemDefault()), ZonedDateTime.of(2018, 9, 24, 10, 0, 0, 0, ZoneId.systemDefault()), Recipient.EXAMPLE, Sender.EXAMPLE, PickupPlace.EXAMPLE, Package.EXAMPLE, Cost.EXAMPLE, Status.READY_FOR_PICKUP, Collections.singleton(Tag.POSTEN));

    @Override
    public PickupNotice withDefaultsForMissingOptionalValues() {
        if (this.status == null) {
            if (this.returnDateTime != null && ZonedDateTime.now().isAfter(this.returnDateTime)) {
                return this.withStatus(Status.UNKNOWN);
            }
            return this.withStatus(Status.READY_FOR_PICKUP);
        }
        return this;
    }

    public String getParcelId() {
        return this.parcelId;
    }

    public String getParcelUUID() {
        return this.parcelUUID;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public String getProductName() {
        return this.productName;
    }

    public ZonedDateTime getArrivalDateTime() {
        return this.arrivalDateTime;
    }

    public ZonedDateTime getReturnDateTime() {
        return this.returnDateTime;
    }

    public Recipient getRecipient() {
        return this.recipient;
    }

    public Sender getSender() {
        return this.sender;
    }

    public PickupPlace getPickupPlace() {
        return this.pickupPlace;
    }

    public Package getThePackage() {
        return this.thePackage;
    }

    public Cost getCost() {
        return this.cost;
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PickupNotice)) {
            return false;
        }
        PickupNotice other = (PickupNotice)o;
        String this$parcelId = this.getParcelId();
        String other$parcelId = other.getParcelId();
        if (this$parcelId == null ? other$parcelId != null : !this$parcelId.equals(other$parcelId)) {
            return false;
        }
        String this$parcelUUID = this.getParcelUUID();
        String other$parcelUUID = other.getParcelUUID();
        if (this$parcelUUID == null ? other$parcelUUID != null : !this$parcelUUID.equals(other$parcelUUID)) {
            return false;
        }
        Barcode this$barcode = this.getBarcode();
        Barcode other$barcode = other.getBarcode();
        if (this$barcode == null ? other$barcode != null : !((Object)this$barcode).equals(other$barcode)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        ZonedDateTime this$arrivalDateTime = this.getArrivalDateTime();
        ZonedDateTime other$arrivalDateTime = other.getArrivalDateTime();
        if (this$arrivalDateTime == null ? other$arrivalDateTime != null : !((Object)this$arrivalDateTime).equals(other$arrivalDateTime)) {
            return false;
        }
        ZonedDateTime this$returnDateTime = this.getReturnDateTime();
        ZonedDateTime other$returnDateTime = other.getReturnDateTime();
        if (this$returnDateTime == null ? other$returnDateTime != null : !((Object)this$returnDateTime).equals(other$returnDateTime)) {
            return false;
        }
        Recipient this$recipient = this.getRecipient();
        Recipient other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient)) {
            return false;
        }
        Sender this$sender = this.getSender();
        Sender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        PickupPlace this$pickupPlace = this.getPickupPlace();
        PickupPlace other$pickupPlace = other.getPickupPlace();
        if (this$pickupPlace == null ? other$pickupPlace != null : !((Object)this$pickupPlace).equals(other$pickupPlace)) {
            return false;
        }
        Package this$thePackage = this.getThePackage();
        Package other$thePackage = other.getThePackage();
        if (this$thePackage == null ? other$thePackage != null : !((Object)this$thePackage).equals(other$thePackage)) {
            return false;
        }
        Cost this$cost = this.getCost();
        Cost other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Set<Tag> this$tags = this.getTags();
        Set<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parcelId = this.getParcelId();
        result = result * 59 + ($parcelId == null ? 43 : $parcelId.hashCode());
        String $parcelUUID = this.getParcelUUID();
        result = result * 59 + ($parcelUUID == null ? 43 : $parcelUUID.hashCode());
        Barcode $barcode = this.getBarcode();
        result = result * 59 + ($barcode == null ? 43 : ((Object)$barcode).hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        ZonedDateTime $arrivalDateTime = this.getArrivalDateTime();
        result = result * 59 + ($arrivalDateTime == null ? 43 : ((Object)$arrivalDateTime).hashCode());
        ZonedDateTime $returnDateTime = this.getReturnDateTime();
        result = result * 59 + ($returnDateTime == null ? 43 : ((Object)$returnDateTime).hashCode());
        Recipient $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
        Sender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        PickupPlace $pickupPlace = this.getPickupPlace();
        result = result * 59 + ($pickupPlace == null ? 43 : ((Object)$pickupPlace).hashCode());
        Package $thePackage = this.getThePackage();
        result = result * 59 + ($thePackage == null ? 43 : ((Object)$thePackage).hashCode());
        Cost $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Set<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "PickupNotice(parcelId=" + this.getParcelId() + ", parcelUUID=" + this.getParcelUUID() + ", barcode=" + this.getBarcode() + ", productName=" + this.getProductName() + ", arrivalDateTime=" + this.getArrivalDateTime() + ", returnDateTime=" + this.getReturnDateTime() + ", recipient=" + this.getRecipient() + ", sender=" + this.getSender() + ", pickupPlace=" + this.getPickupPlace() + ", thePackage=" + this.getThePackage() + ", cost=" + this.getCost() + ", status=" + (Object)((Object)this.getStatus()) + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"parcelId", "parcelUUID", "barcode", "productName", "arrivalDateTime", "returnDateTime", "recipient", "sender", "pickupPlace", "thePackage", "cost", "status", "tags"})
    public PickupNotice(String parcelId, String parcelUUID, Barcode barcode, String productName, ZonedDateTime arrivalDateTime, ZonedDateTime returnDateTime, Recipient recipient, Sender sender, PickupPlace pickupPlace, Package thePackage, Cost cost, Status status, Set<Tag> tags) {
        this.parcelId = parcelId;
        this.parcelUUID = parcelUUID;
        this.barcode = barcode;
        this.productName = productName;
        this.arrivalDateTime = arrivalDateTime;
        this.returnDateTime = returnDateTime;
        this.recipient = recipient;
        this.sender = sender;
        this.pickupPlace = pickupPlace;
        this.thePackage = thePackage;
        this.cost = cost;
        this.status = status;
        this.tags = tags;
    }

    private PickupNotice() {
        this.parcelId = null;
        this.parcelUUID = null;
        this.barcode = null;
        this.productName = null;
        this.arrivalDateTime = null;
        this.returnDateTime = null;
        this.recipient = null;
        this.sender = null;
        this.pickupPlace = null;
        this.thePackage = null;
        this.cost = null;
        this.status = null;
        this.tags = null;
    }

    public PickupNotice withParcelId(String parcelId) {
        return this.parcelId == parcelId ? this : new PickupNotice(parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withParcelUUID(String parcelUUID) {
        return this.parcelUUID == parcelUUID ? this : new PickupNotice(this.parcelId, parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withBarcode(Barcode barcode) {
        return this.barcode == barcode ? this : new PickupNotice(this.parcelId, this.parcelUUID, barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withProductName(String productName) {
        return this.productName == productName ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withArrivalDateTime(ZonedDateTime arrivalDateTime) {
        return this.arrivalDateTime == arrivalDateTime ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withReturnDateTime(ZonedDateTime returnDateTime) {
        return this.returnDateTime == returnDateTime ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withRecipient(Recipient recipient) {
        return this.recipient == recipient ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withSender(Sender sender) {
        return this.sender == sender ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, sender, this.pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withPickupPlace(PickupPlace pickupPlace) {
        return this.pickupPlace == pickupPlace ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, pickupPlace, this.thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withThePackage(Package thePackage) {
        return this.thePackage == thePackage ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, thePackage, this.cost, this.status, this.tags);
    }

    public PickupNotice withCost(Cost cost) {
        return this.cost == cost ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, cost, this.status, this.tags);
    }

    public PickupNotice withStatus(Status status) {
        return this.status == status ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, status, this.tags);
    }

    public PickupNotice withTags(Set<Tag> tags) {
        return this.tags == tags ? this : new PickupNotice(this.parcelId, this.parcelUUID, this.barcode, this.productName, this.arrivalDateTime, this.returnDateTime, this.recipient, this.sender, this.pickupPlace, this.thePackage, this.cost, this.status, tags);
    }
}

