/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.pickup;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.pickup.Status;

@XmlRootElement(name="pickup-notice-status")
@Description(value="Updates to status for PickupNotice")
public final class PickupNoticeStatus
implements DataType {
    @XmlElement(name="status", required=true)
    @Description(value="The status of the PickupNotice")
    @NotNull
    @Valid
    private final Status status;
    @XmlElement(name="occurrence-datetime")
    @Description(value="ISO8601 full DateTime for time of occurrence")
    private final ZonedDateTime occurrenceDatetime;
    public static PickupNoticeStatus EXAMPLE = new PickupNoticeStatus(Status.READY_FOR_PICKUP, ZonedDateTime.of(2019, 1, 10, 10, 10, 0, 0, ZoneId.systemDefault()));

    public Status getStatus() {
        return this.status;
    }

    public ZonedDateTime getOccurrenceDatetime() {
        return this.occurrenceDatetime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PickupNoticeStatus)) {
            return false;
        }
        PickupNoticeStatus other = (PickupNoticeStatus)o;
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ZonedDateTime this$occurrenceDatetime = this.getOccurrenceDatetime();
        ZonedDateTime other$occurrenceDatetime = other.getOccurrenceDatetime();
        return !(this$occurrenceDatetime == null ? other$occurrenceDatetime != null : !((Object)this$occurrenceDatetime).equals(other$occurrenceDatetime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ZonedDateTime $occurrenceDatetime = this.getOccurrenceDatetime();
        result = result * 59 + ($occurrenceDatetime == null ? 43 : ((Object)$occurrenceDatetime).hashCode());
        return result;
    }

    public String toString() {
        return "PickupNoticeStatus(status=" + (Object)((Object)this.getStatus()) + ", occurrenceDatetime=" + this.getOccurrenceDatetime() + ")";
    }

    @ConstructorProperties(value={"status", "occurrenceDatetime"})
    public PickupNoticeStatus(Status status, ZonedDateTime occurrenceDatetime) {
        this.status = status;
        this.occurrenceDatetime = occurrenceDatetime;
    }

    private PickupNoticeStatus() {
        this.status = null;
        this.occurrenceDatetime = null;
    }

    public PickupNoticeStatus withStatus(Status status) {
        return this.status == status ? this : new PickupNoticeStatus(status, this.occurrenceDatetime);
    }

    public PickupNoticeStatus withOccurrenceDatetime(ZonedDateTime occurrenceDatetime) {
        return this.occurrenceDatetime == occurrenceDatetime ? this : new PickupNoticeStatus(this.status, occurrenceDatetime);
    }
}

