/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.proof.MaanedsTidspunkt;
import no.digipost.api.datatypes.types.proof.TidsPeriode;

@XmlType
public final class AarligRepeterendePeriode
implements TidsPeriode {
    @XmlElement(name="start-aar")
    @Description(value="")
    private final Integer startaar;
    @XmlElement(name="slutt-aar")
    @Description(value="")
    private final Integer sluttaar;
    @XmlElement(name="fra", required=true)
    @NotNull
    @Description(value="")
    private final MaanedsTidspunkt fra;
    @XmlElement(name="til", required=true)
    @NotNull
    @Description(value="")
    private final MaanedsTidspunkt til;
    public static AarligRepeterendePeriode EXAMPLE = new AarligRepeterendePeriode(2020, 2022, new MaanedsTidspunkt(1, 1, null, null, "Europe/Oslo"), new MaanedsTidspunkt(12, 31, null, null, "+2:00"));

    public Integer getStartaar() {
        return this.startaar;
    }

    public Integer getSluttaar() {
        return this.sluttaar;
    }

    public MaanedsTidspunkt getFra() {
        return this.fra;
    }

    public MaanedsTidspunkt getTil() {
        return this.til;
    }

    public String toString() {
        return "AarligRepeterendePeriode(startaar=" + this.getStartaar() + ", sluttaar=" + this.getSluttaar() + ", fra=" + this.getFra() + ", til=" + this.getTil() + ")";
    }

    @ConstructorProperties(value={"startaar", "sluttaar", "fra", "til"})
    public AarligRepeterendePeriode(Integer startaar, Integer sluttaar, MaanedsTidspunkt fra, MaanedsTidspunkt til) {
        this.startaar = startaar;
        this.sluttaar = sluttaar;
        this.fra = fra;
        this.til = til;
    }

    private AarligRepeterendePeriode() {
        this.startaar = null;
        this.sluttaar = null;
        this.fra = null;
        this.til = null;
    }

    public AarligRepeterendePeriode withStartaar(Integer startaar) {
        return this.startaar == startaar ? this : new AarligRepeterendePeriode(startaar, this.sluttaar, this.fra, this.til);
    }

    public AarligRepeterendePeriode withSluttaar(Integer sluttaar) {
        return this.sluttaar == sluttaar ? this : new AarligRepeterendePeriode(this.startaar, sluttaar, this.fra, this.til);
    }

    public AarligRepeterendePeriode withFra(MaanedsTidspunkt fra) {
        return this.fra == fra ? this : new AarligRepeterendePeriode(this.startaar, this.sluttaar, fra, this.til);
    }

    public AarligRepeterendePeriode withTil(MaanedsTidspunkt til) {
        return this.til == til ? this : new AarligRepeterendePeriode(this.startaar, this.sluttaar, this.fra, til);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AarligRepeterendePeriode)) {
            return false;
        }
        AarligRepeterendePeriode other = (AarligRepeterendePeriode)o;
        Integer this$startaar = this.getStartaar();
        Integer other$startaar = other.getStartaar();
        if (this$startaar == null ? other$startaar != null : !((Object)this$startaar).equals(other$startaar)) {
            return false;
        }
        Integer this$sluttaar = this.getSluttaar();
        Integer other$sluttaar = other.getSluttaar();
        if (this$sluttaar == null ? other$sluttaar != null : !((Object)this$sluttaar).equals(other$sluttaar)) {
            return false;
        }
        MaanedsTidspunkt this$fra = this.getFra();
        MaanedsTidspunkt other$fra = other.getFra();
        if (this$fra == null ? other$fra != null : !((Object)this$fra).equals(other$fra)) {
            return false;
        }
        MaanedsTidspunkt this$til = this.getTil();
        MaanedsTidspunkt other$til = other.getTil();
        return !(this$til == null ? other$til != null : !((Object)this$til).equals(other$til));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $startaar = this.getStartaar();
        result = result * 59 + ($startaar == null ? 43 : ((Object)$startaar).hashCode());
        Integer $sluttaar = this.getSluttaar();
        result = result * 59 + ($sluttaar == null ? 43 : ((Object)$sluttaar).hashCode());
        MaanedsTidspunkt $fra = this.getFra();
        result = result * 59 + ($fra == null ? 43 : ((Object)$fra).hashCode());
        MaanedsTidspunkt $til = this.getTil();
        result = result * 59 + ($til == null ? 43 : ((Object)$til).hashCode());
        return result;
    }
}

