/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class MaanedsTidspunkt {
    @XmlElement(name="maaned", required=true)
    @Size(min=1, max=12)
    @NotNull
    @Description(value="")
    private final @Size(min=1, max=12) @NotNull Integer maaned;
    @XmlElement(name="dag", required=true)
    @Size(min=1, max=31)
    @NotNull
    @Description(value="")
    private final @Size(min=1, max=31) @NotNull Integer dag;
    @XmlElement(name="time")
    @Size(min=1, max=23)
    @Description(value="")
    private final @Size(min=1, max=23) Integer time;
    @XmlElement(name="min")
    @Size(min=1, max=59)
    @Description(value="")
    private final @Size(min=1, max=59) Integer min;
    @XmlElement(name="tidssone", defaultValue="+02:00")
    @Pattern(regexp="Z|[+-][01]\\d:{0,1}[0-5]\\d|[+-][01]\\d")
    @Description(value="Tidssone iht ISO8601")
    private final @Pattern(regexp="Z|[+-][01]\\d:{0,1}[0-5]\\d|[+-][01]\\d") String tidssone;
    public static MaanedsTidspunkt EXAMPLE = new MaanedsTidspunkt(5, 9, null, null, "+02:00");

    public Integer getMaaned() {
        return this.maaned;
    }

    public Integer getDag() {
        return this.dag;
    }

    public Integer getTime() {
        return this.time;
    }

    public Integer getMin() {
        return this.min;
    }

    public String getTidssone() {
        return this.tidssone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaanedsTidspunkt)) {
            return false;
        }
        MaanedsTidspunkt other = (MaanedsTidspunkt)o;
        Integer this$maaned = this.getMaaned();
        Integer other$maaned = other.getMaaned();
        if (this$maaned == null ? other$maaned != null : !((Object)this$maaned).equals(other$maaned)) {
            return false;
        }
        Integer this$dag = this.getDag();
        Integer other$dag = other.getDag();
        if (this$dag == null ? other$dag != null : !((Object)this$dag).equals(other$dag)) {
            return false;
        }
        Integer this$time = this.getTime();
        Integer other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Integer this$min = this.getMin();
        Integer other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        String this$tidssone = this.getTidssone();
        String other$tidssone = other.getTidssone();
        return !(this$tidssone == null ? other$tidssone != null : !this$tidssone.equals(other$tidssone));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maaned = this.getMaaned();
        result = result * 59 + ($maaned == null ? 43 : ((Object)$maaned).hashCode());
        Integer $dag = this.getDag();
        result = result * 59 + ($dag == null ? 43 : ((Object)$dag).hashCode());
        Integer $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Integer $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        String $tidssone = this.getTidssone();
        result = result * 59 + ($tidssone == null ? 43 : $tidssone.hashCode());
        return result;
    }

    public String toString() {
        return "MaanedsTidspunkt(maaned=" + this.getMaaned() + ", dag=" + this.getDag() + ", time=" + this.getTime() + ", min=" + this.getMin() + ", tidssone=" + this.getTidssone() + ")";
    }

    @ConstructorProperties(value={"maaned", "dag", "time", "min", "tidssone"})
    public MaanedsTidspunkt(Integer maaned, Integer dag, Integer time, Integer min, String tidssone) {
        this.maaned = maaned;
        this.dag = dag;
        this.time = time;
        this.min = min;
        this.tidssone = tidssone;
    }

    private MaanedsTidspunkt() {
        this.maaned = null;
        this.dag = null;
        this.time = null;
        this.min = null;
        this.tidssone = null;
    }

    public MaanedsTidspunkt withMaaned(Integer maaned) {
        return this.maaned == maaned ? this : new MaanedsTidspunkt(maaned, this.dag, this.time, this.min, this.tidssone);
    }

    public MaanedsTidspunkt withDag(Integer dag) {
        return this.dag == dag ? this : new MaanedsTidspunkt(this.maaned, dag, this.time, this.min, this.tidssone);
    }

    public MaanedsTidspunkt withTime(Integer time) {
        return this.time == time ? this : new MaanedsTidspunkt(this.maaned, this.dag, time, this.min, this.tidssone);
    }

    public MaanedsTidspunkt withMin(Integer min) {
        return this.min == min ? this : new MaanedsTidspunkt(this.maaned, this.dag, this.time, min, this.tidssone);
    }

    public MaanedsTidspunkt withTidssone(String tidssone) {
        return this.tidssone == tidssone ? this : new MaanedsTidspunkt(this.maaned, this.dag, this.time, this.min, tidssone);
    }
}

