/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Info;
import no.digipost.api.datatypes.types.proof.Bruker;
import no.digipost.api.datatypes.types.proof.GyldighetsPeriode;

@XmlRootElement
@Description(value="Proof description here")
public final class Proof
implements DataType {
    @XmlElement(name="utsteder-visningsnavn", required=true)
    @NotNull
    @Size(max=30)
    @Description(value="")
    private final @NotNull @Size(max=30) String utstederVisningsnavn;
    @XmlElement(name="bakgrunnsfarge")
    @Pattern(regexp="#[A-SFa-f0-9]{6}")
    @Description(value="#RRGGBB fargekode")
    private final @Pattern(regexp="#[A-SFa-f0-9]{6}") String bakgrunnsfarge;
    @XmlElement(name="utstedt-tidspunkt")
    @Description(value="")
    private final ZonedDateTime utstedtTidspunkt;
    @XmlElement(name="gyldighetsperioder", required=true)
    @NotNull
    @Description(value="")
    private final GyldighetsPeriode gyldighetsPerioder;
    @XmlElement(name="bevis-bruker", required=true)
    @NotNull
    @Description(value="")
    private final Bruker bevisBruker;
    @XmlElement(name="tittel", required=true)
    @NotNull
    @Size(max=30)
    @Description(value="")
    private final @NotNull @Size(max=30) String tittel;
    @XmlElement(name="bevis-id-navn")
    @Size(max=100)
    @Description(value="")
    private final @Size(max=100) String bevisIdNavn;
    @XmlElement(name="bevis-id-verdi")
    @Size(max=250)
    @Description(value="")
    private final @Size(max=250) String bevisIdVerdi;
    @XmlElement(name="attributt")
    @Size(max=5)
    @Description(value="")
    private final @Size(max=5) List<Info> attributt;
    @XmlElement(name="info")
    @Size(max=3)
    @Description(value="")
    private final @Size(max=3) List<Info> info;
    public static Proof EXAMPLE = new Proof("Stedsnavn", "#ff0000", ZonedDateTime.of(2019, 5, 23, 10, 0, 0, 0, ZoneId.systemDefault()), GyldighetsPeriode.EXAMPLE, Bruker.EXAMPLE, "Tittel", "ID Navn", "ID Verdi", Collections.singletonList(new Info("Key", "Value")), Collections.singletonList(new Info("Title", "Text")));

    public String getUtstederVisningsnavn() {
        return this.utstederVisningsnavn;
    }

    public String getBakgrunnsfarge() {
        return this.bakgrunnsfarge;
    }

    public ZonedDateTime getUtstedtTidspunkt() {
        return this.utstedtTidspunkt;
    }

    public GyldighetsPeriode getGyldighetsPerioder() {
        return this.gyldighetsPerioder;
    }

    public Bruker getBevisBruker() {
        return this.bevisBruker;
    }

    public String getTittel() {
        return this.tittel;
    }

    public String getBevisIdNavn() {
        return this.bevisIdNavn;
    }

    public String getBevisIdVerdi() {
        return this.bevisIdVerdi;
    }

    public List<Info> getAttributt() {
        return this.attributt;
    }

    public List<Info> getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proof)) {
            return false;
        }
        Proof other = (Proof)o;
        String this$utstederVisningsnavn = this.getUtstederVisningsnavn();
        String other$utstederVisningsnavn = other.getUtstederVisningsnavn();
        if (this$utstederVisningsnavn == null ? other$utstederVisningsnavn != null : !this$utstederVisningsnavn.equals(other$utstederVisningsnavn)) {
            return false;
        }
        String this$bakgrunnsfarge = this.getBakgrunnsfarge();
        String other$bakgrunnsfarge = other.getBakgrunnsfarge();
        if (this$bakgrunnsfarge == null ? other$bakgrunnsfarge != null : !this$bakgrunnsfarge.equals(other$bakgrunnsfarge)) {
            return false;
        }
        ZonedDateTime this$utstedtTidspunkt = this.getUtstedtTidspunkt();
        ZonedDateTime other$utstedtTidspunkt = other.getUtstedtTidspunkt();
        if (this$utstedtTidspunkt == null ? other$utstedtTidspunkt != null : !((Object)this$utstedtTidspunkt).equals(other$utstedtTidspunkt)) {
            return false;
        }
        GyldighetsPeriode this$gyldighetsPerioder = this.getGyldighetsPerioder();
        GyldighetsPeriode other$gyldighetsPerioder = other.getGyldighetsPerioder();
        if (this$gyldighetsPerioder == null ? other$gyldighetsPerioder != null : !((Object)this$gyldighetsPerioder).equals(other$gyldighetsPerioder)) {
            return false;
        }
        Bruker this$bevisBruker = this.getBevisBruker();
        Bruker other$bevisBruker = other.getBevisBruker();
        if (this$bevisBruker == null ? other$bevisBruker != null : !((Object)this$bevisBruker).equals(other$bevisBruker)) {
            return false;
        }
        String this$tittel = this.getTittel();
        String other$tittel = other.getTittel();
        if (this$tittel == null ? other$tittel != null : !this$tittel.equals(other$tittel)) {
            return false;
        }
        String this$bevisIdNavn = this.getBevisIdNavn();
        String other$bevisIdNavn = other.getBevisIdNavn();
        if (this$bevisIdNavn == null ? other$bevisIdNavn != null : !this$bevisIdNavn.equals(other$bevisIdNavn)) {
            return false;
        }
        String this$bevisIdVerdi = this.getBevisIdVerdi();
        String other$bevisIdVerdi = other.getBevisIdVerdi();
        if (this$bevisIdVerdi == null ? other$bevisIdVerdi != null : !this$bevisIdVerdi.equals(other$bevisIdVerdi)) {
            return false;
        }
        List<Info> this$attributt = this.getAttributt();
        List<Info> other$attributt = other.getAttributt();
        if (this$attributt == null ? other$attributt != null : !((Object)this$attributt).equals(other$attributt)) {
            return false;
        }
        List<Info> this$info = this.getInfo();
        List<Info> other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $utstederVisningsnavn = this.getUtstederVisningsnavn();
        result = result * 59 + ($utstederVisningsnavn == null ? 43 : $utstederVisningsnavn.hashCode());
        String $bakgrunnsfarge = this.getBakgrunnsfarge();
        result = result * 59 + ($bakgrunnsfarge == null ? 43 : $bakgrunnsfarge.hashCode());
        ZonedDateTime $utstedtTidspunkt = this.getUtstedtTidspunkt();
        result = result * 59 + ($utstedtTidspunkt == null ? 43 : ((Object)$utstedtTidspunkt).hashCode());
        GyldighetsPeriode $gyldighetsPerioder = this.getGyldighetsPerioder();
        result = result * 59 + ($gyldighetsPerioder == null ? 43 : ((Object)$gyldighetsPerioder).hashCode());
        Bruker $bevisBruker = this.getBevisBruker();
        result = result * 59 + ($bevisBruker == null ? 43 : ((Object)$bevisBruker).hashCode());
        String $tittel = this.getTittel();
        result = result * 59 + ($tittel == null ? 43 : $tittel.hashCode());
        String $bevisIdNavn = this.getBevisIdNavn();
        result = result * 59 + ($bevisIdNavn == null ? 43 : $bevisIdNavn.hashCode());
        String $bevisIdVerdi = this.getBevisIdVerdi();
        result = result * 59 + ($bevisIdVerdi == null ? 43 : $bevisIdVerdi.hashCode());
        List<Info> $attributt = this.getAttributt();
        result = result * 59 + ($attributt == null ? 43 : ((Object)$attributt).hashCode());
        List<Info> $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "Proof(utstederVisningsnavn=" + this.getUtstederVisningsnavn() + ", bakgrunnsfarge=" + this.getBakgrunnsfarge() + ", utstedtTidspunkt=" + this.getUtstedtTidspunkt() + ", gyldighetsPerioder=" + this.getGyldighetsPerioder() + ", bevisBruker=" + this.getBevisBruker() + ", tittel=" + this.getTittel() + ", bevisIdNavn=" + this.getBevisIdNavn() + ", bevisIdVerdi=" + this.getBevisIdVerdi() + ", attributt=" + this.getAttributt() + ", info=" + this.getInfo() + ")";
    }

    @ConstructorProperties(value={"utstederVisningsnavn", "bakgrunnsfarge", "utstedtTidspunkt", "gyldighetsPerioder", "bevisBruker", "tittel", "bevisIdNavn", "bevisIdVerdi", "attributt", "info"})
    public Proof(String utstederVisningsnavn, String bakgrunnsfarge, ZonedDateTime utstedtTidspunkt, GyldighetsPeriode gyldighetsPerioder, Bruker bevisBruker, String tittel, String bevisIdNavn, String bevisIdVerdi, List<Info> attributt, List<Info> info) {
        this.utstederVisningsnavn = utstederVisningsnavn;
        this.bakgrunnsfarge = bakgrunnsfarge;
        this.utstedtTidspunkt = utstedtTidspunkt;
        this.gyldighetsPerioder = gyldighetsPerioder;
        this.bevisBruker = bevisBruker;
        this.tittel = tittel;
        this.bevisIdNavn = bevisIdNavn;
        this.bevisIdVerdi = bevisIdVerdi;
        this.attributt = attributt;
        this.info = info;
    }

    private Proof() {
        this.utstederVisningsnavn = null;
        this.bakgrunnsfarge = null;
        this.utstedtTidspunkt = null;
        this.gyldighetsPerioder = null;
        this.bevisBruker = null;
        this.tittel = null;
        this.bevisIdNavn = null;
        this.bevisIdVerdi = null;
        this.attributt = null;
        this.info = null;
    }

    public Proof withUtstederVisningsnavn(String utstederVisningsnavn) {
        return this.utstederVisningsnavn == utstederVisningsnavn ? this : new Proof(utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withBakgrunnsfarge(String bakgrunnsfarge) {
        return this.bakgrunnsfarge == bakgrunnsfarge ? this : new Proof(this.utstederVisningsnavn, bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withUtstedtTidspunkt(ZonedDateTime utstedtTidspunkt) {
        return this.utstedtTidspunkt == utstedtTidspunkt ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withGyldighetsPerioder(GyldighetsPeriode gyldighetsPerioder) {
        return this.gyldighetsPerioder == gyldighetsPerioder ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withBevisBruker(Bruker bevisBruker) {
        return this.bevisBruker == bevisBruker ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withTittel(String tittel) {
        return this.tittel == tittel ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withBevisIdNavn(String bevisIdNavn) {
        return this.bevisIdNavn == bevisIdNavn ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, bevisIdNavn, this.bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withBevisIdVerdi(String bevisIdVerdi) {
        return this.bevisIdVerdi == bevisIdVerdi ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, bevisIdVerdi, this.attributt, this.info);
    }

    public Proof withAttributt(List<Info> attributt) {
        return this.attributt == attributt ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, attributt, this.info);
    }

    public Proof withInfo(List<Info> info) {
        return this.info == info ? this : new Proof(this.utstederVisningsnavn, this.bakgrunnsfarge, this.utstedtTidspunkt, this.gyldighetsPerioder, this.bevisBruker, this.tittel, this.bevisIdNavn, this.bevisIdVerdi, this.attributt, info);
    }
}

