/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.receipt;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
@Description(value="Contains details about a single item (line) on the receipt")
public final class ReceiptLine {
    @XmlElement(name="item-name")
    private final String itemName;
    @XmlElement(name="item-description")
    private final String itemDescription;
    @XmlElement(name="item-code")
    private final String itemCode;
    @XmlElement
    @Description(value="The unit that the item is measured in")
    private final String unit;
    @XmlElement
    private final double quantity;
    @XmlElement(name="item-price")
    @Description(value="Unit item net price")
    private final BigDecimal itemPrice;
    @XmlElement(name="item-vat")
    private final BigDecimal itemVat;
    @XmlElement(name="total-price")
    @Description(value="Total line price")
    private final BigDecimal totalPrice;
    @XmlElement(name="total-vat")
    @Description(value="Total line vat amount")
    private final BigDecimal totalVat;
    @XmlElement
    @Description(value="The amount of discount given")
    private final BigDecimal discount;
    @XmlElement
    private final String serialNumber;
    @XmlElement
    private final String eanCode;
    public static final ReceiptLine EXAMPLE = new ReceiptLine("Tall Cafe latte", "Tall vanilla latte with extra sugar", "0000012", "cup", 2.0, new BigDecimal("29.90"), new BigDecimal("5.98"), new BigDecimal("59.80"), new BigDecimal("11.96"), new BigDecimal("5.50"), "XY12345325GF", "1345678");

    public BigDecimal getVatPercent() {
        if (this.itemPrice != null && this.itemVat != null) {
            if (this.itemVat.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal priceMinusVat = this.itemPrice.subtract(this.itemVat);
            if (priceMinusVat.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.valueOf(100L, 0);
            }
            return this.itemVat.multiply(BigDecimal.valueOf(100L)).divide(priceMinusVat, 4).setScale(0, 4);
        }
        return null;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public BigDecimal getItemPrice() {
        return this.itemPrice;
    }

    public BigDecimal getItemVat() {
        return this.itemVat;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public BigDecimal getTotalVat() {
        return this.totalVat;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getEanCode() {
        return this.eanCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceiptLine)) {
            return false;
        }
        ReceiptLine other = (ReceiptLine)o;
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$itemDescription = this.getItemDescription();
        String other$itemDescription = other.getItemDescription();
        if (this$itemDescription == null ? other$itemDescription != null : !this$itemDescription.equals(other$itemDescription)) {
            return false;
        }
        String this$itemCode = this.getItemCode();
        String other$itemCode = other.getItemCode();
        if (this$itemCode == null ? other$itemCode != null : !this$itemCode.equals(other$itemCode)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
            return false;
        }
        BigDecimal this$itemPrice = this.getItemPrice();
        BigDecimal other$itemPrice = other.getItemPrice();
        if (this$itemPrice == null ? other$itemPrice != null : !((Object)this$itemPrice).equals(other$itemPrice)) {
            return false;
        }
        BigDecimal this$itemVat = this.getItemVat();
        BigDecimal other$itemVat = other.getItemVat();
        if (this$itemVat == null ? other$itemVat != null : !((Object)this$itemVat).equals(other$itemVat)) {
            return false;
        }
        BigDecimal this$totalPrice = this.getTotalPrice();
        BigDecimal other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !((Object)this$totalPrice).equals(other$totalPrice)) {
            return false;
        }
        BigDecimal this$totalVat = this.getTotalVat();
        BigDecimal other$totalVat = other.getTotalVat();
        if (this$totalVat == null ? other$totalVat != null : !((Object)this$totalVat).equals(other$totalVat)) {
            return false;
        }
        BigDecimal this$discount = this.getDiscount();
        BigDecimal other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$eanCode = this.getEanCode();
        String other$eanCode = other.getEanCode();
        return !(this$eanCode == null ? other$eanCode != null : !this$eanCode.equals(other$eanCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $itemDescription = this.getItemDescription();
        result = result * 59 + ($itemDescription == null ? 43 : $itemDescription.hashCode());
        String $itemCode = this.getItemCode();
        result = result * 59 + ($itemCode == null ? 43 : $itemCode.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        long $quantity = Double.doubleToLongBits(this.getQuantity());
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        BigDecimal $itemPrice = this.getItemPrice();
        result = result * 59 + ($itemPrice == null ? 43 : ((Object)$itemPrice).hashCode());
        BigDecimal $itemVat = this.getItemVat();
        result = result * 59 + ($itemVat == null ? 43 : ((Object)$itemVat).hashCode());
        BigDecimal $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : ((Object)$totalPrice).hashCode());
        BigDecimal $totalVat = this.getTotalVat();
        result = result * 59 + ($totalVat == null ? 43 : ((Object)$totalVat).hashCode());
        BigDecimal $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $eanCode = this.getEanCode();
        result = result * 59 + ($eanCode == null ? 43 : $eanCode.hashCode());
        return result;
    }

    public String toString() {
        return "ReceiptLine(itemName=" + this.getItemName() + ", itemDescription=" + this.getItemDescription() + ", itemCode=" + this.getItemCode() + ", unit=" + this.getUnit() + ", quantity=" + this.getQuantity() + ", itemPrice=" + this.getItemPrice() + ", itemVat=" + this.getItemVat() + ", totalPrice=" + this.getTotalPrice() + ", totalVat=" + this.getTotalVat() + ", discount=" + this.getDiscount() + ", serialNumber=" + this.getSerialNumber() + ", eanCode=" + this.getEanCode() + ")";
    }

    @ConstructorProperties(value={"itemName", "itemDescription", "itemCode", "unit", "quantity", "itemPrice", "itemVat", "totalPrice", "totalVat", "discount", "serialNumber", "eanCode"})
    public ReceiptLine(String itemName, String itemDescription, String itemCode, String unit, double quantity, BigDecimal itemPrice, BigDecimal itemVat, BigDecimal totalPrice, BigDecimal totalVat, BigDecimal discount, String serialNumber, String eanCode) {
        this.itemName = itemName;
        this.itemDescription = itemDescription;
        this.itemCode = itemCode;
        this.unit = unit;
        this.quantity = quantity;
        this.itemPrice = itemPrice;
        this.itemVat = itemVat;
        this.totalPrice = totalPrice;
        this.totalVat = totalVat;
        this.discount = discount;
        this.serialNumber = serialNumber;
        this.eanCode = eanCode;
    }

    private ReceiptLine() {
        this.itemName = null;
        this.itemDescription = null;
        this.itemCode = null;
        this.unit = null;
        this.quantity = 0.0;
        this.itemPrice = null;
        this.itemVat = null;
        this.totalPrice = null;
        this.totalVat = null;
        this.discount = null;
        this.serialNumber = null;
        this.eanCode = null;
    }

    public ReceiptLine withItemName(String itemName) {
        return this.itemName == itemName ? this : new ReceiptLine(itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withItemDescription(String itemDescription) {
        return this.itemDescription == itemDescription ? this : new ReceiptLine(this.itemName, itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withItemCode(String itemCode) {
        return this.itemCode == itemCode ? this : new ReceiptLine(this.itemName, this.itemDescription, itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withUnit(String unit) {
        return this.unit == unit ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withQuantity(double quantity) {
        return this.quantity == quantity ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withItemPrice(BigDecimal itemPrice) {
        return this.itemPrice == itemPrice ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withItemVat(BigDecimal itemVat) {
        return this.itemVat == itemVat ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withTotalPrice(BigDecimal totalPrice) {
        return this.totalPrice == totalPrice ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, totalPrice, this.totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withTotalVat(BigDecimal totalVat) {
        return this.totalVat == totalVat ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, totalVat, this.discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withDiscount(BigDecimal discount) {
        return this.discount == discount ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, discount, this.serialNumber, this.eanCode);
    }

    public ReceiptLine withSerialNumber(String serialNumber) {
        return this.serialNumber == serialNumber ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, serialNumber, this.eanCode);
    }

    public ReceiptLine withEanCode(String eanCode) {
        return this.eanCode == eanCode ? this : new ReceiptLine(this.itemName, this.itemDescription, this.itemCode, this.unit, this.quantity, this.itemPrice, this.itemVat, this.totalPrice, this.totalVat, this.discount, this.serialNumber, eanCode);
    }
}

