/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.receipt;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class VatLevel {
    @XmlElement
    private final BigDecimal grossAmount;
    @XmlElement
    private final BigDecimal netAmount;
    @XmlElement
    private final BigDecimal vat;
    @XmlElement
    @Description(value="VAT percent from 0 to 100")
    private final BigDecimal vatPercent;
    public static final VatLevel EXAMPLE = new VatLevel(new BigDecimal("400.00"), new BigDecimal("320.00"), new BigDecimal("80.00"), new BigDecimal("25.00"));

    public BigDecimal getGrossAmount() {
        return this.grossAmount;
    }

    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public BigDecimal getVat() {
        return this.vat;
    }

    public BigDecimal getVatPercent() {
        return this.vatPercent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VatLevel)) {
            return false;
        }
        VatLevel other = (VatLevel)o;
        BigDecimal this$grossAmount = this.getGrossAmount();
        BigDecimal other$grossAmount = other.getGrossAmount();
        if (this$grossAmount == null ? other$grossAmount != null : !((Object)this$grossAmount).equals(other$grossAmount)) {
            return false;
        }
        BigDecimal this$netAmount = this.getNetAmount();
        BigDecimal other$netAmount = other.getNetAmount();
        if (this$netAmount == null ? other$netAmount != null : !((Object)this$netAmount).equals(other$netAmount)) {
            return false;
        }
        BigDecimal this$vat = this.getVat();
        BigDecimal other$vat = other.getVat();
        if (this$vat == null ? other$vat != null : !((Object)this$vat).equals(other$vat)) {
            return false;
        }
        BigDecimal this$vatPercent = this.getVatPercent();
        BigDecimal other$vatPercent = other.getVatPercent();
        return !(this$vatPercent == null ? other$vatPercent != null : !((Object)this$vatPercent).equals(other$vatPercent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $grossAmount = this.getGrossAmount();
        result = result * 59 + ($grossAmount == null ? 43 : ((Object)$grossAmount).hashCode());
        BigDecimal $netAmount = this.getNetAmount();
        result = result * 59 + ($netAmount == null ? 43 : ((Object)$netAmount).hashCode());
        BigDecimal $vat = this.getVat();
        result = result * 59 + ($vat == null ? 43 : ((Object)$vat).hashCode());
        BigDecimal $vatPercent = this.getVatPercent();
        result = result * 59 + ($vatPercent == null ? 43 : ((Object)$vatPercent).hashCode());
        return result;
    }

    public String toString() {
        return "VatLevel(grossAmount=" + this.getGrossAmount() + ", netAmount=" + this.getNetAmount() + ", vat=" + this.getVat() + ", vatPercent=" + this.getVatPercent() + ")";
    }

    @ConstructorProperties(value={"grossAmount", "netAmount", "vat", "vatPercent"})
    public VatLevel(BigDecimal grossAmount, BigDecimal netAmount, BigDecimal vat, BigDecimal vatPercent) {
        this.grossAmount = grossAmount;
        this.netAmount = netAmount;
        this.vat = vat;
        this.vatPercent = vatPercent;
    }

    private VatLevel() {
        this.grossAmount = null;
        this.netAmount = null;
        this.vat = null;
        this.vatPercent = null;
    }

    public VatLevel withGrossAmount(BigDecimal grossAmount) {
        return this.grossAmount == grossAmount ? this : new VatLevel(grossAmount, this.netAmount, this.vat, this.vatPercent);
    }

    public VatLevel withNetAmount(BigDecimal netAmount) {
        return this.netAmount == netAmount ? this : new VatLevel(this.grossAmount, netAmount, this.vat, this.vatPercent);
    }

    public VatLevel withVat(BigDecimal vat) {
        return this.vat == vat ? this : new VatLevel(this.grossAmount, this.netAmount, vat, this.vatPercent);
    }

    public VatLevel withVatPercent(BigDecimal vatPercent) {
        return this.vatPercent == vatPercent ? this : new VatLevel(this.grossAmount, this.netAmount, this.vat, vatPercent);
    }
}

