/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDFBoxConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(PDFBoxConfigurer.class);
    private static final String alreadyConfiguredWarn = "PDFBox system properties has already been configured, and calling {} may not be effective! Make sure you call this method early, before using the PdfValidator.";
    private static final AtomicBoolean configured = new AtomicBoolean(false);
    private static final PDFBoxConfiguration pdfBoxConfiguration = new PDFBoxConfiguration();

    public static void doNotConfigurePDFBox() {
        if (configured.get()) {
            LOG.warn(alreadyConfiguredWarn, (Object)"doNotConfigurePDFBox()");
        }
        PDFBoxConfigurer.pdfBoxConfiguration.enabled = false;
    }

    public static void useKcmsServiceProvider(boolean use) {
        if (configured.get()) {
            LOG.warn(alreadyConfiguredWarn, (Object)("useKcmsServiceProvider(" + use + ")"));
        }
        PDFBoxConfigurer.pdfBoxConfiguration.useKcmsServiceProvider = use;
    }

    public static void usePureJavaCMYKConversion(boolean use) {
        if (configured.get()) {
            LOG.warn(alreadyConfiguredWarn, (Object)("usePureJavaCMYKConversion(" + use + ")"));
        }
        PDFBoxConfigurer.pdfBoxConfiguration.useKcmsServiceProvider = use;
    }

    static synchronized void configure() {
        configured.set(true);
        if (PDFBoxConfigurer.pdfBoxConfiguration.enabled) {
            if (PDFBoxConfigurer.pdfBoxConfiguration.useKcmsServiceProvider) {
                LOG.info("Configuring sun.java2d.cmm=sun.java2d.cmm.kcms.KcmsServiceProvider as described at https://pdfbox.apache.org/2.0/getting-started.html#pdfbox-and-java-8 to increase PDF color operation.");
                System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
            }
            if (PDFBoxConfigurer.pdfBoxConfiguration.usePureJavaCMYKConversion) {
                LOG.info("Configuring org.apache.pdfbox.rendering.UsePureJavaCMYKConversion=true as described at https://pdfbox.apache.org/2.0/getting-started.html#rendering-performance to increase PDF rendering performance.");
                System.setProperty("org.apache.pdfbox.rendering.UsePureJavaCMYKConversion", "true");
            }
        } else {
            LOG.info("Using default settings for PDFBox for printability-validator library");
        }
    }

    private PDFBoxConfigurer() {
    }

    static final class PDFBoxConfiguration {
        volatile boolean enabled = true;
        volatile boolean useKcmsServiceProvider = true;
        volatile boolean usePureJavaCMYKConversion = true;

        private PDFBoxConfiguration() {
        }
    }
}

