/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client;

import java.net.Socket;
import java.net.URI;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import no.digipost.signature.client.Certificates;
import no.digipost.signature.client.ClientMetadata;
import no.digipost.signature.client.ServiceUri;
import no.digipost.signature.client.asice.ASiCEConfiguration;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.asice.DumpDocumentBundleToDisk;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.KeyException;
import no.digipost.signature.client.core.internal.http.AddRequestHeaderFilter;
import no.digipost.signature.client.core.internal.http.HttpIntegrationConfiguration;
import no.digipost.signature.client.core.internal.http.PostenEnterpriseCertificateStrategy;
import no.digipost.signature.client.core.internal.security.ProvidesCertificateResourcePaths;
import no.digipost.signature.client.core.internal.security.TrustStoreLoader;
import no.digipost.signature.client.core.internal.xml.JaxbMessageReaderWriterProvider;
import no.digipost.signature.client.security.KeyStoreConfig;
import no.motif.Singular;
import no.motif.Strings;
import no.motif.f.Do;
import no.motif.f.Predicate;
import no.motif.single.Optional;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConfiguration
implements ProvidesCertificateResourcePaths,
HttpIntegrationConfiguration,
ASiCEConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConfiguration.class);
    private static final String JAVA_DESCRIPTION = System.getProperty("java.vendor", "unknown Java") + ", " + System.getProperty("java.version", "unknown version");
    public static final String MANDATORY_USER_AGENT = "Posten signering Java API Client/" + ClientMetadata.VERSION + " (" + JAVA_DESCRIPTION + ")";
    public static final String HTTP_REQUEST_RESPONSE_LOGGER_NAME = "no.digipost.signature.client.http.requestresponse";
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    private final Configurable<? extends Configuration> jaxrsConfig;
    private final KeyStoreConfig keyStoreConfig;
    private final Iterable<String> certificatePaths;
    private final Optional<Sender> sender;
    private final URI signatureServiceRoot;
    private final Iterable<DocumentBundleProcessor> documentBundleProcessors;

    private ClientConfiguration(KeyStoreConfig keyStoreConfig, Configurable<? extends Configuration> jaxrsConfig, Optional<Sender> sender, URI serviceRoot, Iterable<String> certificatePaths, Iterable<DocumentBundleProcessor> documentBundleProcessors) {
        this.keyStoreConfig = keyStoreConfig;
        this.jaxrsConfig = jaxrsConfig;
        this.sender = sender;
        this.signatureServiceRoot = serviceRoot;
        this.certificatePaths = certificatePaths;
        this.documentBundleProcessors = documentBundleProcessors;
    }

    @Override
    public KeyStoreConfig getKeyStoreConfig() {
        return this.keyStoreConfig;
    }

    @Override
    public Optional<Sender> getGlobalSender() {
        return this.sender;
    }

    @Override
    public Iterable<DocumentBundleProcessor> getDocumentBundleProcessors() {
        return this.documentBundleProcessors;
    }

    @Override
    public URI getServiceRoot() {
        return this.signatureServiceRoot;
    }

    @Override
    public Iterable<String> getCertificatePaths() {
        return this.certificatePaths;
    }

    @Override
    public Configuration getJaxrsConfiguration() {
        return this.jaxrsConfig.getConfiguration();
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLContexts.custom().loadKeyMaterial(this.keyStoreConfig.keyStore, this.keyStoreConfig.privatekeyPassword.toCharArray(), new PrivateKeyStrategy(){

                public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                    return ((ClientConfiguration)ClientConfiguration.this).keyStoreConfig.alias;
                }
            }).loadTrustMaterial(TrustStoreLoader.build(this), (TrustStrategy)new PostenEnterpriseCertificateStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            if (e instanceof UnrecoverableKeyException && "Given final block not properly padded".equals(e.getMessage())) {
                throw new KeyException("Unable to load key from keystore, because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'. Possible causes:\n* Wrong password for private key (the password for the keystore and the private key may not be the same)\n* Multiple private keys in the keystore with different passwords (private keys in the same key store must have the same password)", e);
            }
            throw new KeyException("Unable to create the SSLContext, because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
        }
    }

    public static Builder builder(KeyStoreConfig keystore) {
        return new Builder(keystore);
    }

    public static class Builder {
        private final Configurable<? extends Configuration> jaxrsConfig;
        private final KeyStoreConfig keyStoreConfig;
        private int socketTimeoutMs = 10000;
        private int connectTimeoutMs = 10000;
        private Optional<String> customUserAgentPart = Singular.none();
        private URI serviceRoot;
        private Optional<Sender> globalSender;
        private Iterable<String> certificatePaths;
        private Optional<LoggingFilter> loggingFilter;
        private List<DocumentBundleProcessor> documentBundleProcessors;

        private Builder(KeyStoreConfig keyStoreConfig) {
            this.serviceRoot = ServiceUri.PRODUCTION.uri;
            this.globalSender = Singular.none();
            this.certificatePaths = Certificates.PRODUCTION.certificatePaths;
            this.loggingFilter = Singular.none();
            this.documentBundleProcessors = new ArrayList<DocumentBundleProcessor>();
            this.keyStoreConfig = keyStoreConfig;
            this.jaxrsConfig = new ClientConfig();
        }

        public Builder serviceUri(ServiceUri environment) {
            return this.serviceUri(environment.uri);
        }

        public Builder serviceUri(URI uri) {
            this.serviceRoot = uri;
            return this;
        }

        public Builder socketTimeoutMillis(int millis) {
            this.socketTimeoutMs = millis;
            return this;
        }

        public Builder connectTimeoutMillis(int millis) {
            this.connectTimeoutMs = millis;
            return this;
        }

        public Builder trustStore(Certificates certificates) {
            if (certificates == Certificates.TEST) {
                LOG.warn("Using test certificates in trust store. This should never be done for production environments.");
            }
            return this.trustStore((Iterable<String>)Singular.the((Object)((Object)certificates)).split(Certificates.getCertificatePaths));
        }

        public Builder trustStore(String ... certificatePaths) {
            return this.trustStore(Arrays.asList(certificatePaths));
        }

        public Builder trustStore(Iterable<String> certificatePaths) {
            this.certificatePaths = certificatePaths;
            return this;
        }

        public Builder globalSender(Sender sender) {
            this.globalSender = Singular.optional((Object)sender);
            return this;
        }

        public Builder includeInUserAgent(String userAgentCustomPart) {
            this.customUserAgentPart = Singular.optional((Predicate)Strings.nonblank, (Object)userAgentCustomPart);
            return this;
        }

        public Builder enableRequestAndResponseLogging() {
            this.loggingFilter = Singular.the((Object)new LoggingFilter(java.util.logging.Logger.getLogger(ClientConfiguration.HTTP_REQUEST_RESPONSE_LOGGER_NAME), 16384)).asOptional();
            return this;
        }

        public Builder enableDocumentBundleDiskDump(Path directory) {
            return this.addDocumentBundleProcessor(new DumpDocumentBundleToDisk(directory));
        }

        public Builder addDocumentBundleProcessor(DocumentBundleProcessor processor) {
            this.documentBundleProcessors.add(processor);
            return this;
        }

        public Builder customizeJaxRs(Do<? super Configurable<? extends Configuration>> customizer) {
            customizer.with(this.jaxrsConfig);
            return this;
        }

        public ClientConfiguration build() {
            this.jaxrsConfig.property("jersey.config.client.readTimeout", (Object)this.socketTimeoutMs);
            this.jaxrsConfig.property("jersey.config.client.connectTimeout", (Object)this.connectTimeoutMs);
            this.jaxrsConfig.register(MultiPartFeature.class);
            this.jaxrsConfig.register(JaxbMessageReaderWriterProvider.class);
            this.jaxrsConfig.register((Object)new AddRequestHeaderFilter("User-Agent", this.createUserAgentString()));
            for (LoggingFilter loggingFilter : this.loggingFilter) {
                this.jaxrsConfig.register((Object)loggingFilter);
            }
            return new ClientConfiguration(this.keyStoreConfig, this.jaxrsConfig, this.globalSender, this.serviceRoot, this.certificatePaths, this.documentBundleProcessors);
        }

        String createUserAgentString() {
            return (String)this.customUserAgentPart.map(Strings.inBetween((String)"(", (String)")")).map(Strings.prepend((String)(MANDATORY_USER_AGENT + " "))).orElse((Object)MANDATORY_USER_AGENT);
        }
    }
}

