/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import no.digipost.signature.client.asice.ASiCEAttachable;
import no.digipost.signature.client.asice.ASiCEConfiguration;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.asice.archive.CreateZip;
import no.digipost.signature.client.asice.manifest.Manifest;
import no.digipost.signature.client.asice.manifest.ManifestCreator;
import no.digipost.signature.client.asice.signature.CreateSignature;
import no.digipost.signature.client.asice.signature.Signature;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.SenderNotSpecifiedException;
import no.digipost.signature.client.security.KeyStoreConfig;
import no.motif.single.Optional;

public class CreateASiCE<JOB extends SignatureJob> {
    private final CreateZip createZip = new CreateZip();
    private final CreateSignature createSignature = new CreateSignature();
    private final ManifestCreator<JOB> manifestCreator;
    private final Optional<Sender> globalSender;
    private final KeyStoreConfig keyStoreConfig;
    private final Iterable<DocumentBundleProcessor> documentBundleProcessors;

    public CreateASiCE(ManifestCreator<JOB> manifestCreator, ASiCEConfiguration clientConfiguration) {
        this.manifestCreator = manifestCreator;
        this.globalSender = clientConfiguration.getGlobalSender();
        this.keyStoreConfig = clientConfiguration.getKeyStoreConfig();
        this.documentBundleProcessors = clientConfiguration.getDocumentBundleProcessors();
    }

    public DocumentBundle createASiCE(JOB job) {
        Sender sender = (Sender)job.getSender().or(this.globalSender).orElseThrow(SenderNotSpecifiedException.SENDER_NOT_SPECIFIED);
        Manifest manifest = this.manifestCreator.createManifest(job, sender);
        ArrayList<ASiCEAttachable> files = new ArrayList<ASiCEAttachable>();
        files.add(job.getDocument());
        files.add(manifest);
        Signature signature = this.createSignature.createSignature(files, this.keyStoreConfig);
        files.add(signature);
        byte[] zipped = this.createZip.zipIt(files);
        for (DocumentBundleProcessor processor : this.documentBundleProcessors) {
            try {
                ByteArrayInputStream zipStream = new ByteArrayInputStream(zipped);
                Throwable throwable = null;
                try {
                    processor.process((SignatureJob)job, zipStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipStream == null) continue;
                    if (throwable != null) {
                        try {
                            zipStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zipStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return new DocumentBundle(zipped);
    }
}

