/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.core.SignatureJob;
import no.motif.Base;
import no.motif.Singular;
import no.motif.Strings;
import no.motif.f.Fn;
import no.motif.single.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpDocumentBundleToDisk
implements DocumentBundleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DumpDocumentBundleToDisk.class);
    private static final String TIMESTAMP_PATTERN = "yyyyMMddHHmmssSSS";
    private final Path directory;
    static final Fn<String, String> referenceFilenamePart = Base.first((Fn)new Fn<String, String>(){

        public String $(String reference) {
            return reference.replace(' ', '_');
        }
    }).then(Strings.append((String)"-"));

    public DumpDocumentBundleToDisk(Path directory) {
        this.directory = directory;
    }

    @Override
    public void process(SignatureJob job, InputStream documentBundle) throws IOException {
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            throw new InvalidDirectoryException(this.directory);
        }
        SimpleDateFormat timestampFormat = new SimpleDateFormat(TIMESTAMP_PATTERN);
        Optional reference = Singular.optional((Object)job.getReference());
        String filename = timestampFormat.format(new Date()) + "-" + (String)reference.map(referenceFilenamePart).orElse((Object)"") + "asice.zip";
        Path target = this.directory.resolve(filename);
        LOG.info("Dumping document bundle{}to {}", reference.map(Strings.inBetween((String)" for job with reference '", (String)"' ")).orElse((Object)" "), (Object)target);
        Files.copy(documentBundle, target, new CopyOption[0]);
    }

    public static class InvalidDirectoryException
    extends IOException {
        public InvalidDirectoryException(Path path) {
            super("The path " + path + (!Files.exists(path, new LinkOption[0]) ? " does not exist" : " is not a valid directory"));
        }
    }
}

