/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.archive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import no.digipost.signature.client.asice.ASiCEAttachable;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;

public class CreateZip {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] zipIt(List<ASiCEAttachable> files) {
        try (ByteArrayOutputStream archive = new ByteArrayOutputStream();){
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(archive);){
                for (ASiCEAttachable file : files) {
                    ZipEntry zipEntry = new ZipEntry(file.getFileName());
                    zipEntry.setSize(file.getBytes().length);
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(file.getBytes());
                    zipOutputStream.closeEntry();
                }
            }
            byte[] byArray = archive.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

