/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.manifest;

import java.util.ArrayList;
import no.digipost.signature.api.xml.XMLAuthenticationLevel;
import no.digipost.signature.api.xml.XMLAvailability;
import no.digipost.signature.api.xml.XMLEmail;
import no.digipost.signature.api.xml.XMLEnabled;
import no.digipost.signature.api.xml.XMLIdentifierInSignedDocuments;
import no.digipost.signature.api.xml.XMLNotifications;
import no.digipost.signature.api.xml.XMLNotificationsUsingLookup;
import no.digipost.signature.api.xml.XMLPortalDocument;
import no.digipost.signature.api.xml.XMLPortalSignatureJobManifest;
import no.digipost.signature.api.xml.XMLPortalSigner;
import no.digipost.signature.api.xml.XMLSender;
import no.digipost.signature.api.xml.XMLSignatureType;
import no.digipost.signature.api.xml.XMLSigningOnBehalfOf;
import no.digipost.signature.api.xml.XMLSms;
import no.digipost.signature.client.asice.manifest.ManifestCreator;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.SignerNotSpecifiedException;
import no.digipost.signature.client.core.internal.MarshallableEnum;
import no.digipost.signature.client.portal.Notifications;
import no.digipost.signature.client.portal.NotificationsUsingLookup;
import no.digipost.signature.client.portal.PortalDocument;
import no.digipost.signature.client.portal.PortalJob;
import no.digipost.signature.client.portal.PortalSigner;

public class CreatePortalManifest
extends ManifestCreator<PortalJob> {
    @Override
    Object buildXmlManifest(PortalJob job, Sender sender) {
        ArrayList<XMLPortalSigner> xmlSigners = new ArrayList<XMLPortalSigner>();
        for (PortalSigner signer : job.getSigners()) {
            XMLPortalSigner xmlPortalSigner = this.generateSigner(signer);
            if (signer.getNotifications() != null) {
                xmlPortalSigner.setNotifications(this.generateNotifications(signer.getNotifications()));
            } else if (signer.getNotificationsUsingLookup() != null) {
                xmlPortalSigner.setNotificationsUsingLookup(this.generateNotificationsUsingLookup(signer.getNotificationsUsingLookup()));
            }
            xmlSigners.add(xmlPortalSigner);
        }
        PortalDocument document = job.getDocument();
        return new XMLPortalSignatureJobManifest().withSigners(xmlSigners).withRequiredAuthentication((XMLAuthenticationLevel)job.getRequiredAuthentication().map(MarshallableEnum.To.xmlValue()).orNull()).withSender(new XMLSender().withOrganizationNumber(sender.getOrganizationNumber())).withDocument(new XMLPortalDocument().withTitle(document.getTitle()).withNonsensitiveTitle(document.getNonsensitiveTitle()).withDescription(document.getMessage()).withHref(document.getFileName()).withMime(document.getMimeType())).withAvailability(new XMLAvailability().withActivationTime(job.getActivationTime()).withAvailableSeconds(job.getAvailableSeconds())).withIdentifierInSignedDocuments((XMLIdentifierInSignedDocuments)job.getIdentifierInSignedDocuments().map(MarshallableEnum.To.xmlValue()).orNull());
    }

    private XMLPortalSigner generateSigner(PortalSigner signer) {
        XMLPortalSigner xmlSigner = new XMLPortalSigner().withOrder(Integer.valueOf(signer.getOrder())).withSignatureType((XMLSignatureType)signer.getSignatureType().map(MarshallableEnum.To.xmlValue()).orNull()).withOnBehalfOf((XMLSigningOnBehalfOf)signer.getOnBehalfOf().map(MarshallableEnum.To.xmlValue()).orNull());
        if (signer.isIdentifiedByPersonalIdentificationNumber()) {
            xmlSigner.setPersonalIdentificationNumber((String)signer.getIdentifier().orElseThrow(SignerNotSpecifiedException.SIGNER_NOT_SPECIFIED));
        } else {
            xmlSigner.setIdentifiedByContactInformation(new XMLEnabled());
        }
        return xmlSigner;
    }

    private XMLNotificationsUsingLookup generateNotificationsUsingLookup(NotificationsUsingLookup notificationsUsingLookup) {
        XMLNotificationsUsingLookup xmlNotificationsUsingLookup = new XMLNotificationsUsingLookup();
        if (notificationsUsingLookup.shouldSendEmail) {
            xmlNotificationsUsingLookup.setEmail(new XMLEnabled());
        }
        if (notificationsUsingLookup.shouldSendSms) {
            xmlNotificationsUsingLookup.setSms(new XMLEnabled());
        }
        return xmlNotificationsUsingLookup;
    }

    private XMLNotifications generateNotifications(Notifications notifications) {
        XMLNotifications xmlNotifications = new XMLNotifications();
        if (notifications.shouldSendEmail()) {
            xmlNotifications.setEmail(new XMLEmail().withAddress(notifications.getEmailAddress()));
        }
        if (notifications.shouldSendSms()) {
            xmlNotifications.setSms(new XMLSms().withNumber(notifications.getMobileNumber()));
        }
        return xmlNotifications;
    }
}

