/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.BrokerNotAuthorizedException;
import no.digipost.signature.client.core.exceptions.CantQueryStatusException;
import no.digipost.signature.client.core.exceptions.InvalidStatusQueryTokenException;
import no.digipost.signature.client.core.exceptions.JobCannotBeCancelledException;
import no.digipost.signature.client.core.exceptions.NotCancellableException;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.SenderNotSpecifiedException;
import no.digipost.signature.client.core.exceptions.SignatureException;
import no.digipost.signature.client.core.exceptions.TooEagerPollingException;
import no.digipost.signature.client.core.exceptions.UnexpectedResponseException;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientExceptionMapper;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.core.internal.ErrorCodes;
import no.digipost.signature.client.core.internal.Target;
import no.digipost.signature.client.core.internal.http.ResponseStatus;
import no.digipost.signature.client.core.internal.http.SignatureHttpClient;
import no.motif.Singular;
import no.motif.Strings;
import no.motif.f.Predicate;
import no.motif.single.Optional;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHelper.class);
    public static final String NEXT_PERMITTED_POLL_TIME_HEADER = "X-Next-permitted-poll-time";
    private final SignatureHttpClient httpClient;
    private final Optional<Sender> globalSender;
    private final ClientExceptionMapper clientExceptionMapper;

    public ClientHelper(SignatureHttpClient httpClient, Optional<Sender> globalSender) {
        this.httpClient = httpClient;
        this.globalSender = globalSender;
        this.clientExceptionMapper = new ClientExceptionMapper();
    }

    public XMLDirectSignatureJobResponse sendSignatureJobRequest(XMLDirectSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        final Sender actualSender = (Sender)sender.or(this.globalSender).orElseThrow(SenderNotSpecifiedException.SENDER_NOT_SPECIFIED);
        final BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        final BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(new Callable<XMLDirectSignatureJobResponse>(){

            @Override
            public XMLDirectSignatureJobResponse call() {
                return new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.DIRECT.path(actualSender), XMLDirectSignatureJobResponse.class);
            }
        });
    }

    public XMLPortalSignatureJobResponse sendPortalSignatureJobRequest(XMLPortalSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        final Sender actualSender = (Sender)sender.or(this.globalSender).orElseThrow(SenderNotSpecifiedException.SENDER_NOT_SPECIFIED);
        final BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        final BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(new Callable<XMLPortalSignatureJobResponse>(){

            @Override
            public XMLPortalSignatureJobResponse call() {
                return new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.PORTAL.path(actualSender), XMLPortalSignatureJobResponse.class);
            }
        });
    }

    public XMLDirectSignatureJobStatusResponse sendSignatureJobStatusRequest(final String statusUrl) {
        return this.call(new Callable<XMLDirectSignatureJobStatusResponse>(){

            @Override
            public XMLDirectSignatureJobStatusResponse call() {
                try (Response response = ClientHelper.this.httpClient.target(statusUrl).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get();){
                    XMLError error;
                    Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                    if (status == Response.Status.OK) {
                        XMLDirectSignatureJobStatusResponse xMLDirectSignatureJobStatusResponse = (XMLDirectSignatureJobStatusResponse)response.readEntity(XMLDirectSignatureJobStatusResponse.class);
                        return xMLDirectSignatureJobStatusResponse;
                    }
                    if (status == Response.Status.FORBIDDEN) {
                        XMLError error2 = ClientHelper.extractError(response);
                        if (ErrorCodes.INVALID_STATUS_QUERY_TOKEN.sameAs(error2.getErrorCode())) {
                            throw new InvalidStatusQueryTokenException(statusUrl, error2.getErrorMessage());
                        }
                    } else if (status == Response.Status.NOT_FOUND && ErrorCodes.SIGNING_CEREMONY_NOT_COMPLETED.sameAs((error = ClientHelper.extractError(response)).getErrorCode())) {
                        throw new CantQueryStatusException(status, error.getErrorMessage());
                    }
                    throw ClientHelper.this.exceptionForGeneralError(response);
                }
            }
        });
    }

    public InputStream getSignedDocumentStream(final String uri) {
        return this.call(new Callable<InputStream>(){

            @Override
            public InputStream call() {
                return (InputStream)ClientHelper.this.parseResponse(ClientHelper.this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(), InputStream.class);
            }
        });
    }

    public void cancel(final Cancellable cancellable) {
        this.call(new Runnable(){

            @Override
            public void run() {
                if (cancellable.getCancellationUrl() != null) {
                    String url = cancellable.getCancellationUrl().getUrl();
                    try (Response response = ClientHelper.this.postEmptyEntity(url);){
                        Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                        if (status == Response.Status.OK) {
                            return;
                        }
                        if (status == Response.Status.CONFLICT) {
                            XMLError error = ClientHelper.extractError(response);
                            throw new JobCannotBeCancelledException(status, error.getErrorCode(), error.getErrorMessage());
                        }
                        throw ClientHelper.this.exceptionForGeneralError(response);
                    }
                }
                throw new NotCancellableException();
            }
        });
    }

    public XMLPortalSignatureJobStatusChangeResponse getPortalStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.PORTAL, XMLPortalSignatureJobStatusChangeResponse.class);
    }

    public XMLDirectSignatureJobStatusResponse getDirectStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.DIRECT, XMLDirectSignatureJobStatusResponse.class);
    }

    private <RESPONSE_CLASS> RESPONSE_CLASS getStatusChange(final Optional<Sender> sender, final Target target, final Class<RESPONSE_CLASS> responseClass) {
        return (RESPONSE_CLASS)this.call(new Callable<RESPONSE_CLASS>(){

            @Override
            public RESPONSE_CLASS call() {
                try (Response response = ClientHelper.this.httpClient.signatureServiceRoot().path(target.path((Sender)sender.or(ClientHelper.this.globalSender).orElseThrow(SenderNotSpecifiedException.SENDER_NOT_SPECIFIED))).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get();){
                    Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                    if (status == Response.Status.NO_CONTENT) {
                        Object RESPONSE_CLASS = null;
                        return RESPONSE_CLASS;
                    }
                    if (status == Response.Status.OK) {
                        Object object = response.readEntity(responseClass);
                        return object;
                    }
                    if (status == ResponseStatus.Custom.TOO_MANY_REQUESTS) {
                        throw new TooEagerPollingException(response.getHeaderString(ClientHelper.NEXT_PERMITTED_POLL_TIME_HEADER));
                    }
                    throw ClientHelper.this.exceptionForGeneralError(response);
                }
            }
        });
    }

    public void confirm(final Confirmable confirmable) {
        this.call(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    if (confirmable.getConfirmationReference() != null) {
                        String url = confirmable.getConfirmationReference().getConfirmationUrl();
                        LOG.info("Sends confirmation for '{}' to URL {}", (Object)confirmable, (Object)url);
                        try (Response response = ClientHelper.this.postEmptyEntity(url);){
                            Response.StatusType status = ResponseStatus.resolve(response.getStatus());
                            if (status != Response.Status.OK) {
                                throw ClientHelper.this.exceptionForGeneralError(response);
                            }
                            break block5;
                        }
                    }
                    LOG.info("Does not need to send confirmation for '{}'", (Object)confirmable);
                }
            }
        });
    }

    private <T> T call(Callable<T> producer) {
        return this.clientExceptionMapper.doWithMappedClientException(producer);
    }

    private void call(Runnable action) {
        this.clientExceptionMapper.doWithMappedClientException(action);
    }

    private Response postEmptyEntity(String uri) {
        return this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).header("Content-Length", (Object)0).post(Entity.entity(null, (MediaType)MediaType.APPLICATION_XML_TYPE));
    }

    private <T> T parseResponse(Response response, Class<T> responseType) {
        Response.StatusType status = ResponseStatus.resolve(response.getStatus());
        if (status == Response.Status.OK) {
            return (T)response.readEntity(responseType);
        }
        throw this.exceptionForGeneralError(response);
    }

    private SignatureException exceptionForGeneralError(Response response) {
        XMLError error = ClientHelper.extractError(response);
        if (ErrorCodes.BROKER_NOT_AUTHORIZED.sameAs(error.getErrorCode())) {
            return new BrokerNotAuthorizedException(error);
        }
        return new UnexpectedResponseException((Object)error, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
    }

    private static XMLError extractError(Response response) {
        XMLError error = null;
        Optional responseContentType = Singular.optional((Object)response.getHeaderString("Content-Type"));
        if (responseContentType.isSome() && MediaType.valueOf((String)((String)responseContentType.get())).equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            try {
                response.bufferEntity();
                error = (XMLError)response.readEntity(XMLError.class);
            }
            catch (Exception e) {
                throw new UnexpectedResponseException((Object)("Content-Type " + (String)responseContentType.orElse((Object)"unknown") + ": " + (String)Singular.optional((Predicate)Strings.nonblank, (Object)response.readEntity(String.class)).orElse((Object)"<no content in response>")), (Throwable)e, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
            }
        } else {
            throw new UnexpectedResponseException((Object)("Content-Type " + (String)responseContentType.orElse((Object)"unknown") + ": " + (String)Singular.optional((Predicate)Strings.nonblank, (Object)response.readEntity(String.class)).orElse((Object)"<no content in response>")), ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
        }
        if (error == null) {
            throw new UnexpectedResponseException(null, ResponseStatus.resolve(response.getStatus()), new Response.StatusType[]{Response.Status.OK});
        }
        return error;
    }

    private class UsingBodyParts {
        private final List<BodyPart> parts;

        UsingBodyParts(BodyPart ... parts) {
            this.parts = Arrays.asList(parts);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        <T> T postAsMultiPart(String path, Class<T> responseType) {
            try {
                Throwable throwable = null;
                try (MultiPart multiPart = new MultiPart();){
                    Object object;
                    for (BodyPart bodyPart : this.parts) {
                        multiPart.bodyPart(bodyPart);
                    }
                    Response response = ClientHelper.this.httpClient.signatureServiceRoot().path(path).request().header("Content-Type", (Object)multiPart.getMediaType()).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
                    try {
                        object = ClientHelper.this.parseResponse(response, responseType);
                    }
                    catch (Throwable throwable2) {
                        try {
                            response.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    response.close();
                    return (T)object;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

