/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import no.digipost.signature.client.core.exceptions.SecurityException;
import org.apache.http.conn.ssl.TrustStrategy;

public class PostenEnterpriseCertificateStrategy
implements TrustStrategy {
    private static final String POSTEN_ORGANIZATION_NUMBER = "984661185";
    private static final String COMMON_NAME_POSTEN = "CN=984661185";
    private static final String SERIALNUMBER_POSTEN = "SERIALNUMBER=984661185";

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String subjectDN = chain[0].getSubjectDN().getName();
        if (!this.isPostenEnterpriseCertiticate(subjectDN)) {
            throw new SecurityException("Could not find correct organization number in server certificate. Make sure the server URI is correct.\nActual certificate: " + subjectDN + ".\nExpected certificate issued to organization number " + POSTEN_ORGANIZATION_NUMBER + "\nThis could indicate a misconfiguration of the client or server, or potentially a man-in-the-middle attack.");
        }
        return false;
    }

    private boolean isPostenEnterpriseCertiticate(String subjectDN) {
        String lowerCaseSubjectDN = subjectDN.toLowerCase();
        return lowerCaseSubjectDN.contains(SERIALNUMBER_POSTEN.toLowerCase()) || lowerCaseSubjectDN.contains(COMMON_NAME_POSTEN.toLowerCase());
    }
}

