/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.util.Objects;
import javax.ws.rs.core.Response;

public class ResponseStatus {
    public static Response.StatusType resolve(int code) {
        Object status = Response.Status.fromStatusCode((int)code);
        if (status == null) {
            status = Custom.fromStatusCode(code);
        }
        if (status == null) {
            status = ResponseStatus.unknown(code);
        }
        return status;
    }

    public static Response.StatusType unknown(int code) {
        return new Unknown(code);
    }

    public static final class Unknown
    implements Response.StatusType {
        final int code;
        final Response.Status.Family family;
        final String reason;

        private Unknown(int code) {
            this.code = code;
            this.family = Response.Status.Family.familyOf((int)code);
            this.reason = "(" + this.family + ", unrecognized status code)";
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.reason;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public String toString() {
            return this.code + " " + this.reason;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Unknown) {
                Unknown that = (Unknown)obj;
                return Objects.equals(this.code, that.code);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.code);
        }
    }

    public static enum Custom implements Response.StatusType
    {
        UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
        TOO_MANY_REQUESTS(429, "Too Many Requests");

        private int code;
        private String reason;
        private Response.Status.Family family;

        public static Custom fromStatusCode(int code) {
            for (Custom s : Custom.values()) {
                if (s.code != code) continue;
                return s;
            }
            return null;
        }

        private Custom(int code, String reasonPhrase) {
            this.code = code;
            this.reason = reasonPhrase;
            this.family = Response.Status.Family.familyOf((int)code);
        }

        public int getStatusCode() {
            return this.code;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public String getReasonPhrase() {
            return this.reason;
        }

        public String toString() {
            return this.code + " " + this.reason;
        }
    }
}

