/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import no.digipost.signature.client.core.internal.http.HttpIntegrationConfiguration;
import no.digipost.signature.client.core.internal.http.SignatureHttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.glassfish.jersey.client.JerseyClientBuilder;

public class SignatureHttpClientFactory {
    public static SignatureHttpClient create(HttpIntegrationConfiguration config) {
        Client jerseyClient = JerseyClientBuilder.newBuilder().withConfig(config.getJaxrsConfiguration()).sslContext(config.getSSLContext()).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        return new DefaultClient(jerseyClient, config.getServiceRoot());
    }

    private static final class DefaultClient
    implements SignatureHttpClient {
        private final Client jerseyClient;
        private final WebTarget signatureServiceRoot;

        DefaultClient(Client jerseyClient, URI root) {
            this.jerseyClient = jerseyClient;
            this.signatureServiceRoot = jerseyClient.target(root);
        }

        @Override
        public WebTarget target(String uri) {
            return this.jerseyClient.target(uri);
        }

        @Override
        public WebTarget signatureServiceRoot() {
            return this.signatureServiceRoot;
        }
    }
}

