/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import no.digipost.signature.client.core.Document;

public class DirectDocument
extends Document {
    private DirectDocument(String title, String message, String fileName, Document.FileType fileType, byte[] document) {
        super(title, message, fileName, fileType, document);
    }

    public static Builder builder(String title, String fileName, byte[] document) {
        return new Builder(title, fileName, document);
    }

    public static class Builder {
        private String title;
        private String fileName;
        private byte[] document;
        private String message;
        private Document.FileType fileType = Document.FileType.PDF;

        public Builder(String title, String fileName, byte[] document) {
            this.title = title;
            this.fileName = fileName;
            this.document = document;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder fileType(Document.FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public DirectDocument build() {
            return new DirectDocument(this.title, this.message, this.fileName, this.fileType, this.document);
        }
    }
}

