/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.internal.JobCustomizations;
import no.digipost.signature.client.direct.DirectDocument;
import no.digipost.signature.client.direct.DirectSigner;
import no.digipost.signature.client.direct.StatusRetrievalMethod;
import no.digipost.signature.client.direct.WithExitUrls;
import no.motif.Singular;
import no.motif.single.Optional;

public class DirectJob
implements SignatureJob,
WithExitUrls {
    private String reference;
    private List<DirectSigner> signers;
    private DirectDocument document;
    private String completionUrl;
    private String rejectionUrl;
    private String errorUrl;
    private Optional<Sender> sender = Singular.none();
    private Optional<StatusRetrievalMethod> statusRetrievalMethod = Singular.none();
    private Optional<AuthenticationLevel> requiredAuthentication = Singular.none();
    private Optional<IdentifierInSignedDocuments> identifierInSignedDocuments = Singular.none();

    private DirectJob(List<DirectSigner> signers, DirectDocument document, String completionUrl, String rejectionUrl, String errorUrl) {
        this.signers = Collections.unmodifiableList(new ArrayList<DirectSigner>(signers));
        this.document = document;
        this.completionUrl = completionUrl;
        this.rejectionUrl = rejectionUrl;
        this.errorUrl = errorUrl;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public DirectDocument getDocument() {
        return this.document;
    }

    @Override
    public Optional<Sender> getSender() {
        return this.sender;
    }

    @Override
    public String getCompletionUrl() {
        return this.completionUrl;
    }

    @Override
    public String getRejectionUrl() {
        return this.rejectionUrl;
    }

    @Override
    public String getErrorUrl() {
        return this.errorUrl;
    }

    @Override
    public Optional<AuthenticationLevel> getRequiredAuthentication() {
        return this.requiredAuthentication;
    }

    @Override
    public Optional<IdentifierInSignedDocuments> getIdentifierInSignedDocuments() {
        return this.identifierInSignedDocuments;
    }

    public List<DirectSigner> getSigners() {
        return this.signers;
    }

    public Optional<StatusRetrievalMethod> getStatusRetrievalMethod() {
        return this.statusRetrievalMethod;
    }

    public static Builder builder(DirectDocument document, WithExitUrls hasExitUrls, DirectSigner ... signers) {
        return DirectJob.builder(document, hasExitUrls, Arrays.asList(signers));
    }

    public static Builder builder(DirectDocument document, WithExitUrls hasExitUrls, List<DirectSigner> signers) {
        return new Builder(signers, document, hasExitUrls.getCompletionUrl(), hasExitUrls.getRejectionUrl(), hasExitUrls.getErrorUrl());
    }

    public static class Builder
    implements JobCustomizations<Builder> {
        private final DirectJob target;
        private boolean built = false;

        public Builder(List<DirectSigner> signers, DirectDocument document, String completionUrl, String rejectionUrl, String errorUrl) {
            this.target = new DirectJob(signers, document, completionUrl, rejectionUrl, errorUrl);
        }

        @Override
        public Builder withReference(UUID uuid) {
            return this.withReference(uuid.toString());
        }

        @Override
        public Builder withReference(String reference) {
            this.target.reference = reference;
            return this;
        }

        @Override
        public Builder withSender(Sender sender) {
            this.target.sender = Singular.optional((Object)sender);
            return this;
        }

        @Override
        public Builder requireAuthentication(AuthenticationLevel level) {
            this.target.requiredAuthentication = Singular.optional((Object)level);
            return this;
        }

        @Override
        public Builder withIdentifierInSignedDocuments(IdentifierInSignedDocuments identifier) {
            this.target.identifierInSignedDocuments = Singular.optional((Object)identifier);
            return this;
        }

        public Builder retrieveStatusBy(StatusRetrievalMethod statusRetrievalMethod) {
            this.target.statusRetrievalMethod = Singular.optional((Object)statusRetrievalMethod);
            return this;
        }

        public DirectJob build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

