/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.List;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.direct.DirectJobStatus;
import no.digipost.signature.client.direct.Signature;
import no.motif.Iterate;
import no.motif.f.Fn0;

public class DirectJobStatusResponse
implements Confirmable {
    public static final DirectJobStatusResponse NO_UPDATED_STATUS = new DirectJobStatusResponse(null, DirectJobStatus.NO_CHANGES, null, null, null){

        @Override
        public long getSignatureJobId() {
            throw new IllegalStateException("There were " + this + ", and querying the job ID is a programming error. Use the method is(" + DirectJobStatusResponse.class.getSimpleName() + "." + DirectJobStatus.NO_CHANGES.name() + ") to check if there were any status change before attempting to get any further information.");
        }

        @Override
        public String toString() {
            return "no direct jobs with updated status";
        }
    };
    private final Long signatureJobId;
    private final DirectJobStatus status;
    private final ConfirmationReference confirmationReference;
    private final List<Signature> signatures;
    private final PAdESReference pAdESReference;

    public DirectJobStatusResponse(Long signatureJobId, DirectJobStatus signatureJobStatus, ConfirmationReference confirmationUrl, List<Signature> signatures, PAdESReference pAdESReference) {
        this.signatureJobId = signatureJobId;
        this.status = signatureJobStatus;
        this.confirmationReference = confirmationUrl;
        this.signatures = signatures;
        this.pAdESReference = pAdESReference;
    }

    public long getSignatureJobId() {
        return this.signatureJobId;
    }

    public DirectJobStatus getStatus() {
        return this.status;
    }

    public boolean is(DirectJobStatus status) {
        return this.status == status;
    }

    public boolean isPAdESAvailable() {
        return this.pAdESReference != null;
    }

    public PAdESReference getpAdESUrl() {
        return this.pAdESReference;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public Signature getSignatureFrom(String signer) {
        return (Signature)Iterate.on(this.signatures).filter(Signature.signatureFrom(signer)).head().orElseThrow((Fn0)new Fn0<IllegalArgumentException>(){

            public IllegalArgumentException $() {
                return new IllegalArgumentException("Unable to find signature from this signer");
            }
        });
    }

    @Override
    public ConfirmationReference getConfirmationReference() {
        return this.confirmationReference;
    }

    public String toString() {
        return "status for direct job with ID " + this.signatureJobId + ": " + (Object)((Object)this.status);
    }
}

