/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.ArrayList;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLExitUrls;
import no.digipost.signature.api.xml.XMLSignerSpecificUrl;
import no.digipost.signature.api.xml.XMLSignerStatus;
import no.digipost.signature.api.xml.XMLStatusRetrievalMethod;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.MarshallableEnum;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectJobResponse;
import no.digipost.signature.client.direct.DirectJobStatus;
import no.digipost.signature.client.direct.DirectJobStatusResponse;
import no.digipost.signature.client.direct.RedirectUrls;
import no.digipost.signature.client.direct.Signature;
import no.digipost.signature.client.direct.SignerStatus;
import no.motif.Iterate;
import no.motif.f.Fn;
import no.motif.f.Predicate;

final class JaxbEntityMapping {
    JaxbEntityMapping() {
    }

    static XMLDirectSignatureJobRequest toJaxb(DirectJob signatureJob) {
        return new XMLDirectSignatureJobRequest().withReference(signatureJob.getReference()).withExitUrls(new XMLExitUrls().withCompletionUrl(signatureJob.getCompletionUrl()).withRejectionUrl(signatureJob.getRejectionUrl()).withErrorUrl(signatureJob.getErrorUrl())).withStatusRetrievalMethod((XMLStatusRetrievalMethod)signatureJob.getStatusRetrievalMethod().map(MarshallableEnum.To.xmlValue()).orNull());
    }

    static DirectJobResponse fromJaxb(XMLDirectSignatureJobResponse xmlSignatureJobResponse) {
        ArrayList<RedirectUrls.RedirectUrl> redirectUrls = new ArrayList<RedirectUrls.RedirectUrl>();
        for (XMLSignerSpecificUrl redirectUrl : xmlSignatureJobResponse.getRedirectUrls()) {
            redirectUrls.add(new RedirectUrls.RedirectUrl(redirectUrl.getSigner(), redirectUrl.getValue()));
        }
        return new DirectJobResponse(xmlSignatureJobResponse.getSignatureJobId(), redirectUrls, xmlSignatureJobResponse.getStatusUrl());
    }

    static DirectJobStatusResponse fromJaxb(XMLDirectSignatureJobStatusResponse statusResponse) {
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        for (XMLSignerStatus signerStatus : statusResponse.getStatuses()) {
            String xAdESUrl = (String)Iterate.on((Iterable)statusResponse.getXadesUrls()).filter(JaxbEntityMapping.forSigner(signerStatus.getSigner())).head().map(JaxbEntityMapping.getUrl()).orNull();
            signatures.add(new Signature(signerStatus.getSigner(), SignerStatus.fromXmlType(signerStatus.getValue()), signerStatus.getSince(), XAdESReference.of(xAdESUrl)));
        }
        return new DirectJobStatusResponse(statusResponse.getSignatureJobId(), DirectJobStatus.fromXmlType(statusResponse.getSignatureJobStatus()), ConfirmationReference.of(statusResponse.getConfirmationUrl()), signatures, PAdESReference.of(statusResponse.getPadesUrl()));
    }

    private static Fn<XMLSignerSpecificUrl, String> getUrl() {
        return new Fn<XMLSignerSpecificUrl, String>(){

            public String $(XMLSignerSpecificUrl url) {
                return url.getValue();
            }
        };
    }

    private static Predicate<XMLSignerSpecificUrl> forSigner(final String signer) {
        return new Predicate<XMLSignerSpecificUrl>(){

            public boolean $(XMLSignerSpecificUrl url) {
                return url.getSigner().equals(signer);
            }
        };
    }
}

