/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Date;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.PersonalIdentificationNumbers;
import no.digipost.signature.client.direct.SignerStatus;
import no.motif.f.Predicate;

public class Signature {
    private final String signer;
    private final SignerStatus status;
    private final Date statusDateTime;
    private final XAdESReference xAdESReference;

    public Signature(String signer, SignerStatus status, Date statusDateTime, XAdESReference xAdESReference) {
        this.signer = signer;
        this.status = status;
        this.statusDateTime = statusDateTime;
        this.xAdESReference = xAdESReference;
    }

    public String getSigner() {
        return this.signer;
    }

    public boolean isFrom(String personalIdentificationNumber) {
        return this.signer.equals(personalIdentificationNumber);
    }

    public boolean is(SignerStatus status) {
        return this.status == status;
    }

    public SignerStatus getStatus() {
        return this.status;
    }

    public Date getStatusDateTime() {
        return this.statusDateTime;
    }

    public XAdESReference getxAdESUrl() {
        return this.xAdESReference;
    }

    public String toString() {
        return "Signature from " + PersonalIdentificationNumbers.mask(this.signer) + " with status '" + this.status + "' since " + this.statusDateTime + "" + (this.xAdESReference != null ? ". XAdES available at " + this.xAdESReference.getxAdESUrl() : "");
    }

    static Predicate<Signature> signatureFrom(final String signer) {
        return new Predicate<Signature>(){

            public boolean $(Signature signature) {
                return signature.isFrom(signer);
            }
        };
    }
}

