/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SignerStatus {
    public static final SignerStatus REJECTED = new SignerStatus("REJECTED");
    public static final SignerStatus EXPIRED = new SignerStatus("EXPIRED");
    public static final SignerStatus WAITING = new SignerStatus("WAITING");
    public static final SignerStatus SIGNED = new SignerStatus("SIGNED");
    public static final SignerStatus FAILED = new SignerStatus("FAILED");
    private static final List<SignerStatus> KNOWN_STATUSES = Arrays.asList(REJECTED, EXPIRED, WAITING, SIGNED, FAILED);
    private final String identifier;

    public SignerStatus(String identifier) {
        this.identifier = identifier;
    }

    public static SignerStatus fromXmlType(String xmlSignerStatus) {
        for (SignerStatus status : KNOWN_STATUSES) {
            if (!status.is(xmlSignerStatus)) continue;
            return status;
        }
        return new SignerStatus(xmlSignerStatus);
    }

    private boolean is(String xmlSignerStatus) {
        return this.identifier.equals(xmlSignerStatus);
    }

    public boolean equals(Object o) {
        if (o instanceof SignerStatus) {
            SignerStatus that = (SignerStatus)o;
            return Objects.equals(this.identifier, that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

