/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Objects;
import javax.ws.rs.core.UriBuilder;
import no.digipost.signature.client.direct.DirectJobResponse;

public class StatusReference {
    public static final String STATUS_QUERY_TOKEN_PARAM_NAME = "status_query_token";
    private final String statusUrl;
    private final String statusQueryToken;

    public static StatusUrlContruction of(DirectJobResponse response) {
        return StatusReference.ofUrl(response.getStatusUrl());
    }

    public static StatusUrlContruction ofUrl(final String statusUrl) {
        return new StatusUrlContruction(){

            @Override
            public StatusReference withStatusQueryToken(String token) {
                return new StatusReference(statusUrl, token);
            }
        };
    }

    private StatusReference(String statusUrl, String statusQueryToken) {
        this.statusUrl = statusUrl;
        this.statusQueryToken = Objects.requireNonNull(statusQueryToken, STATUS_QUERY_TOKEN_PARAM_NAME);
    }

    public String getStatusUrl() {
        return UriBuilder.fromUri((String)this.statusUrl).queryParam(STATUS_QUERY_TOKEN_PARAM_NAME, new Object[]{this.statusQueryToken}).build(new Object[0]).toString();
    }

    public static abstract class StatusUrlContruction {
        private StatusUrlContruction() {
        }

        public abstract StatusReference withStatusQueryToken(String var1);
    }
}

