/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import no.digipost.signature.client.core.Document;

public class PortalDocument
extends Document {
    private final String nonsensitiveTitle;

    private PortalDocument(String title, String nonsensitiveTitle, String message, String fileName, Document.FileType fileType, byte[] document) {
        super(title, message, fileName, fileType, document);
        this.nonsensitiveTitle = nonsensitiveTitle;
    }

    public String getNonsensitiveTitle() {
        return this.nonsensitiveTitle;
    }

    public static Builder builder(String title, String fileName, byte[] document) {
        return new Builder(title, fileName, document);
    }

    public static class Builder {
        private String title;
        private String nonsensitiveTitle;
        private String fileName;
        private byte[] document;
        private String message;
        private Document.FileType fileType = Document.FileType.PDF;

        public Builder(String title, String fileName, byte[] document) {
            this.title = title;
            this.fileName = fileName;
            this.document = document;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder nonsensitiveTitle(String nonsensitiveTitle) {
            this.nonsensitiveTitle = nonsensitiveTitle;
            return this;
        }

        public Builder fileType(Document.FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public PortalDocument build() {
            return new PortalDocument(this.title, this.nonsensitiveTitle, this.message, this.fileName, this.fileType, this.document);
        }
    }
}

