/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.internal.JobCustomizations;
import no.digipost.signature.client.portal.PortalDocument;
import no.digipost.signature.client.portal.PortalSigner;
import no.motif.Singular;
import no.motif.single.Optional;

public class PortalJob
implements SignatureJob {
    private final List<PortalSigner> signers;
    private final PortalDocument document;
    private String reference;
    private Date activationTime;
    private Long availableSeconds;
    private Optional<Sender> sender = Singular.none();
    private Optional<AuthenticationLevel> requiredAuthentication = Singular.none();
    private Optional<IdentifierInSignedDocuments> identifierInSignedDocuments = Singular.none();

    private PortalJob(List<PortalSigner> signers, PortalDocument document) {
        this.signers = Collections.unmodifiableList(new ArrayList<PortalSigner>(signers));
        this.document = document;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public PortalDocument getDocument() {
        return this.document;
    }

    @Override
    public Optional<Sender> getSender() {
        return this.sender;
    }

    @Override
    public Optional<AuthenticationLevel> getRequiredAuthentication() {
        return this.requiredAuthentication;
    }

    @Override
    public Optional<IdentifierInSignedDocuments> getIdentifierInSignedDocuments() {
        return this.identifierInSignedDocuments;
    }

    public List<PortalSigner> getSigners() {
        return this.signers;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public Long getAvailableSeconds() {
        return this.availableSeconds;
    }

    public static Builder builder(PortalDocument document, PortalSigner ... signers) {
        return PortalJob.builder(document, Arrays.asList(signers));
    }

    public static Builder builder(PortalDocument document, List<PortalSigner> signers) {
        return new Builder(signers, document);
    }

    public static class Builder
    implements JobCustomizations<Builder> {
        private final PortalJob target;
        private boolean built = false;

        private Builder(List<PortalSigner> signers, PortalDocument document) {
            this.target = new PortalJob(signers, document);
        }

        @Override
        public Builder withReference(UUID uuid) {
            return this.withReference(uuid.toString());
        }

        @Override
        public Builder withReference(String reference) {
            this.target.reference = reference;
            return this;
        }

        @Override
        public Builder withSender(Sender sender) {
            this.target.sender = Singular.optional((Object)sender);
            return this;
        }

        @Override
        public Builder requireAuthentication(AuthenticationLevel minimumLevel) {
            this.target.requiredAuthentication = Singular.optional((Object)minimumLevel);
            return this;
        }

        @Override
        public Builder withIdentifierInSignedDocuments(IdentifierInSignedDocuments identifier) {
            this.target.identifierInSignedDocuments = Singular.optional((Object)identifier);
            return this;
        }

        public Builder withActivationTime(Date activationTime) {
            this.target.activationTime = activationTime;
            return this;
        }

        public Builder availableFor(long duration, TimeUnit unit) {
            this.target.availableSeconds = unit.toSeconds(duration);
            return this;
        }

        public PortalJob build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

