/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.portal;

import java.util.List;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.portal.CancellationUrl;
import no.digipost.signature.client.portal.PortalJobStatus;
import no.digipost.signature.client.portal.Signature;
import no.digipost.signature.client.portal.SignerIdentifier;
import no.motif.Iterate;
import no.motif.f.Fn0;

public class PortalJobStatusChanged
implements Confirmable,
Cancellable {
    public static final PortalJobStatusChanged NO_UPDATED_STATUS = new PortalJobStatusChanged(null, PortalJobStatus.NO_CHANGES, null, null, null, null){

        @Override
        public long getSignatureJobId() {
            throw new IllegalStateException("There were " + this + ", and querying the job ID is a programming error. Use the method is(" + PortalJobStatus.class.getSimpleName() + "." + PortalJobStatus.NO_CHANGES.name() + ") to check if there were any status change before attempting to get any further information.");
        }

        @Override
        public String toString() {
            return "no portal jobs with updated status";
        }
    };
    private final Long signatureJobId;
    private final PortalJobStatus status;
    private final PAdESReference pAdESReference;
    private final ConfirmationReference confirmationReference;
    private final CancellationUrl cancellationUrl;
    private final List<Signature> signatures;

    PortalJobStatusChanged(Long signatureJobId, PortalJobStatus status, ConfirmationReference confirmationReference, CancellationUrl cancellationUrl, PAdESReference pAdESReference, List<Signature> signatures) {
        this.signatureJobId = signatureJobId;
        this.status = status;
        this.cancellationUrl = cancellationUrl;
        this.pAdESReference = pAdESReference;
        this.confirmationReference = confirmationReference;
        this.signatures = signatures;
    }

    public long getSignatureJobId() {
        return this.signatureJobId;
    }

    public PortalJobStatus getStatus() {
        return this.status;
    }

    public boolean is(PortalJobStatus status) {
        return this.status == status;
    }

    public boolean isPAdESAvailable() {
        return this.pAdESReference != null;
    }

    public PAdESReference getpAdESUrl() {
        return this.pAdESReference;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public Signature getSignatureFrom(SignerIdentifier signer) {
        return (Signature)Iterate.on(this.signatures).filter(Signature.signatureFrom(signer)).head().orElseThrow((Fn0)new Fn0<IllegalArgumentException>(){

            public IllegalArgumentException $() {
                return new IllegalArgumentException("Unable to find signature from this signer");
            }
        });
    }

    @Override
    public ConfirmationReference getConfirmationReference() {
        return this.confirmationReference;
    }

    @Override
    public CancellationUrl getCancellationUrl() {
        return this.cancellationUrl;
    }

    public String toString() {
        return "updated status for portal job with id " + this.signatureJobId + ": " + (Object)((Object)this.status);
    }
}

