/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import no.digipost.signature.client.asice.ASiCEAttachable;
import no.digipost.signature.client.asice.ASiCEConfiguration;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.DocumentBundleProcessor;
import no.digipost.signature.client.asice.archive.CreateZip;
import no.digipost.signature.client.asice.manifest.Manifest;
import no.digipost.signature.client.asice.manifest.ManifestCreator;
import no.digipost.signature.client.asice.signature.CreateSignature;
import no.digipost.signature.client.asice.signature.Signature;
import no.digipost.signature.client.core.Document;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.internal.ActualSender;
import no.digipost.signature.client.security.KeyStoreConfig;

public class CreateASiCE<JOB extends SignatureJob> {
    private final CreateZip createZip = new CreateZip();
    private final CreateSignature createSignature;
    private final ManifestCreator<JOB> manifestCreator;
    private final Optional<Sender> globalSender;
    private final KeyStoreConfig keyStoreConfig;
    private final Iterable<DocumentBundleProcessor> documentBundleProcessors;

    public CreateASiCE(ManifestCreator<JOB> manifestCreator, ASiCEConfiguration clientConfiguration) {
        this.manifestCreator = manifestCreator;
        this.globalSender = clientConfiguration.getGlobalSender();
        this.keyStoreConfig = clientConfiguration.getKeyStoreConfig();
        this.documentBundleProcessors = clientConfiguration.getDocumentBundleProcessors();
        this.createSignature = new CreateSignature(clientConfiguration.getClock());
    }

    public DocumentBundle createASiCE(JOB job) {
        Sender sender = ActualSender.getActualSender(job.getSender(), this.globalSender);
        Manifest manifest = this.manifestCreator.createManifest(job, sender);
        ArrayList<ASiCEAttachable> files = new ArrayList<ASiCEAttachable>(job.getDocuments());
        files.add((Document)((Object)manifest));
        Signature signature = this.createSignature.createSignature(files, this.keyStoreConfig);
        files.add((Document)((Object)signature));
        byte[] zipped = this.createZip.zipIt(files);
        for (DocumentBundleProcessor processor : this.documentBundleProcessors) {
            try (ByteArrayInputStream zipStream = new ByteArrayInputStream(zipped);){
                processor.process((SignatureJob)job, zipStream);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return new DocumentBundle(zipped);
    }
}

