/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.manifest;

import java.util.ArrayList;
import java.util.stream.Collectors;
import no.digipost.signature.api.xml.XMLAuthenticationLevel;
import no.digipost.signature.api.xml.XMLDirectDocument;
import no.digipost.signature.api.xml.XMLDirectSignatureJobManifest;
import no.digipost.signature.api.xml.XMLDirectSigner;
import no.digipost.signature.api.xml.XMLHref;
import no.digipost.signature.api.xml.XMLIdentifierInSignedDocuments;
import no.digipost.signature.api.xml.XMLSender;
import no.digipost.signature.api.xml.XMLSignatureType;
import no.digipost.signature.api.xml.XMLSigningOnBehalfOf;
import no.digipost.signature.client.asice.manifest.ManifestCreator;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.OnBehalfOf;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureType;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectSigner;

public class CreateDirectManifest
extends ManifestCreator<DirectJob> {
    @Override
    Object buildXmlManifest(DirectJob job, Sender sender) {
        ArrayList<XMLDirectSigner> signers = new ArrayList<XMLDirectSigner>();
        for (DirectSigner signer : job.getSigners()) {
            XMLDirectSigner xmlSigner = new XMLDirectSigner().withSignatureType((XMLSignatureType)signer.getSignatureType().map(SignatureType::getXmlEnumValue).orElse(null)).withOnBehalfOf((XMLSigningOnBehalfOf)signer.getOnBehalfOf().map(OnBehalfOf::getXmlEnumValue).orElse(null));
            if (signer.isIdentifiedByPersonalIdentificationNumber()) {
                xmlSigner.setPersonalIdentificationNumber(signer.getPersonalIdentificationNumber());
            } else {
                xmlSigner.setSignerIdentifier(signer.getCustomIdentifier());
            }
            signers.add(xmlSigner);
        }
        return new XMLDirectSignatureJobManifest().withSigners(signers).withRequiredAuthentication((XMLAuthenticationLevel)job.getRequiredAuthentication().map(AuthenticationLevel::getXmlEnumValue).orElse(null)).withSender(new XMLSender().withOrganizationNumber(sender.getOrganizationNumber())).withTitle(job.getTitle()).withDescription((String)job.getDescription().orElse(null)).withDocuments(job.getDocuments().stream().map(document -> new XMLDirectDocument().withTitle(document.getTitle()).withHref(XMLHref.of((String)document.getFileName())).withMediaType(document.getMediaType())).collect(Collectors.toList())).withIdentifierInSignedDocuments((XMLIdentifierInSignedDocuments)job.getIdentifierInSignedDocuments().map(IdentifierInSignedDocuments::getXmlEnumValue).orElse(null));
    }
}

