/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.asice.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import no.digipost.signature.client.asice.manifest.Manifest;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.XmlValidationException;
import no.digipost.signature.client.core.internal.xml.Marshalling;
import org.springframework.oxm.MarshallingFailureException;
import org.xml.sax.SAXParseException;

public abstract class ManifestCreator<JOB extends SignatureJob> {
    public Manifest createManifest(JOB job, Sender sender) {
        Manifest manifest;
        Object xmlManifest = this.buildXmlManifest(job, sender);
        ByteArrayOutputStream manifestStream = new ByteArrayOutputStream();
        try {
            Marshalling.marshal(xmlManifest, manifestStream);
            manifest = new Manifest(manifestStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    manifestStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MarshallingFailureException e) {
                if (e.getMostSpecificCause() instanceof SAXParseException) {
                    throw new XmlValidationException("Unable to validate generated Manifest XML. This typically happens if one or more values are not in accordance with the XSD. You may inspect the cause (by calling getCause()) to see which constraint has been violated.", (SAXParseException)e.getMostSpecificCause());
                }
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        manifestStream.close();
        return manifest;
    }

    abstract Object buildXmlManifest(JOB var1, Sender var2);
}

