/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLDirectSignerResponse;
import no.digipost.signature.api.xml.XMLDirectSignerUpdateRequest;
import no.digipost.signature.api.xml.XMLEmptyElement;
import no.digipost.signature.api.xml.XMLError;
import no.digipost.signature.api.xml.XMLPortalSignatureJobRequest;
import no.digipost.signature.api.xml.XMLPortalSignatureJobResponse;
import no.digipost.signature.api.xml.XMLPortalSignatureJobStatusChangeResponse;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.exceptions.BrokerNotAuthorizedException;
import no.digipost.signature.client.core.exceptions.CantQueryStatusException;
import no.digipost.signature.client.core.exceptions.DocumentsNotDeletableException;
import no.digipost.signature.client.core.exceptions.InvalidStatusQueryTokenException;
import no.digipost.signature.client.core.exceptions.JobCannotBeCancelledException;
import no.digipost.signature.client.core.exceptions.NotCancellableException;
import no.digipost.signature.client.core.exceptions.RuntimeIOException;
import no.digipost.signature.client.core.exceptions.SignatureException;
import no.digipost.signature.client.core.exceptions.TooEagerPollingException;
import no.digipost.signature.client.core.exceptions.UnexpectedResponseException;
import no.digipost.signature.client.core.internal.ActualSender;
import no.digipost.signature.client.core.internal.Cancellable;
import no.digipost.signature.client.core.internal.ClientExceptionMapper;
import no.digipost.signature.client.core.internal.Confirmable;
import no.digipost.signature.client.core.internal.ErrorCodes;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.Target;
import no.digipost.signature.client.core.internal.http.ResponseStatus;
import no.digipost.signature.client.core.internal.http.SignatureHttpClient;
import no.digipost.signature.client.direct.WithSignerUrl;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHelper.class);
    private static final String NEXT_PERMITTED_POLL_TIME_HEADER = "X-Next-permitted-poll-time";
    private static final String POLLING_QUEUE_QUERY_PARAMETER = "polling_queue";
    private final SignatureHttpClient httpClient;
    private final Optional<Sender> globalSender;
    private final ClientExceptionMapper clientExceptionMapper;

    public ClientHelper(SignatureHttpClient httpClient, Optional<Sender> globalSender) {
        this.httpClient = httpClient;
        this.globalSender = globalSender;
        this.clientExceptionMapper = new ClientExceptionMapper();
    }

    public XMLDirectSignatureJobResponse sendSignatureJobRequest(XMLDirectSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        Sender actualSender = ActualSender.getActualSender(sender, this.globalSender);
        BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(() -> new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.DIRECT.path(actualSender), XMLDirectSignatureJobResponse.class));
    }

    public XMLDirectSignerResponse requestNewRedirectUrl(WithSignerUrl url) {
        try (Response response = this.postEntity(url.getSignerUrl(), new XMLDirectSignerUpdateRequest().withRedirectUrl(new XMLEmptyElement()));){
            XMLDirectSignerResponse xMLDirectSignerResponse = ClientHelper.parseResponse(response, XMLDirectSignerResponse.class);
            return xMLDirectSignerResponse;
        }
    }

    public XMLPortalSignatureJobResponse sendPortalSignatureJobRequest(XMLPortalSignatureJobRequest signatureJobRequest, DocumentBundle documentBundle, Optional<Sender> sender) {
        Sender actualSender = ActualSender.getActualSender(sender, this.globalSender);
        BodyPart signatureJobBodyPart = new BodyPart((Object)signatureJobRequest, MediaType.APPLICATION_XML_TYPE);
        BodyPart documentBundleBodyPart = new BodyPart((Object)documentBundle.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.call(() -> new UsingBodyParts(signatureJobBodyPart, documentBundleBodyPart).postAsMultiPart(Target.PORTAL.path(actualSender), XMLPortalSignatureJobResponse.class));
    }

    public XMLDirectSignatureJobStatusResponse sendSignatureJobStatusRequest(URI statusUrl) {
        return this.call(() -> {
            Invocation.Builder request = this.httpClient.target(statusUrl).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
            try (Response response = request.get();){
                ResponseStatus.resolve(response.getStatus()).expect(Response.Status.Family.SUCCESSFUL).orThrow(status -> {
                    XMLError error;
                    if (status == Response.Status.FORBIDDEN) {
                        XMLError error2 = ClientHelper.extractError(response);
                        if (ErrorCodes.INVALID_STATUS_QUERY_TOKEN.sameAs(error2.getErrorCode())) {
                            return new InvalidStatusQueryTokenException(statusUrl, error2.getErrorMessage());
                        }
                    } else if (status == Response.Status.NOT_FOUND && ErrorCodes.SIGNING_CEREMONY_NOT_COMPLETED.sameAs((error = ClientHelper.extractError(response)).getErrorCode())) {
                        return new CantQueryStatusException((Response.StatusType)status, error.getErrorMessage());
                    }
                    return ClientHelper.exceptionForGeneralError(response);
                });
                XMLDirectSignatureJobStatusResponse xMLDirectSignatureJobStatusResponse = (XMLDirectSignatureJobStatusResponse)response.readEntity(XMLDirectSignatureJobStatusResponse.class);
                return xMLDirectSignatureJobStatusResponse;
            }
        });
    }

    public ResponseInputStream getDataStream(URI uri, MediaType ... acceptedResponses) {
        return this.getDataStream(ignoredRoot -> this.httpClient.target(uri), acceptedResponses);
    }

    public ResponseInputStream getDataStream(UnaryOperator<WebTarget> targetResolver, MediaType ... acceptedResponses) {
        return this.call(() -> {
            Response response = ((WebTarget)targetResolver.apply(this.httpClient.signatureServiceRoot())).request().accept(acceptedResponses).get();
            InputStream inputStream = ClientHelper.parseResponse(response, InputStream.class);
            return new ResponseInputStream(inputStream, response.getLength());
        });
    }

    public void cancel(Cancellable cancellable) {
        this.call(() -> {
            if (cancellable.getCancellationUrl() != null) {
                URI url = cancellable.getCancellationUrl().getUrl();
                try (Response response = this.postEmptyEntity(url);){
                    ResponseStatus.resolve(response.getStatus()).throwIf(Response.Status.CONFLICT, status -> new JobCannotBeCancelledException((Response.StatusType)status, ClientHelper.extractError(response))).expect(Response.Status.Family.SUCCESSFUL).orThrow(status -> ClientHelper.exceptionForGeneralError(response));
                }
            } else {
                throw new NotCancellableException();
            }
        });
    }

    public JobStatusResponse<XMLPortalSignatureJobStatusChangeResponse> getPortalStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.PORTAL, XMLPortalSignatureJobStatusChangeResponse.class);
    }

    public JobStatusResponse<XMLDirectSignatureJobStatusResponse> getDirectStatusChange(Optional<Sender> sender) {
        return this.getStatusChange(sender, Target.DIRECT, XMLDirectSignatureJobStatusResponse.class);
    }

    private <RESPONSE_CLASS> JobStatusResponse<RESPONSE_CLASS> getStatusChange(Optional<Sender> sender, Target target, Class<RESPONSE_CLASS> responseClass) {
        return this.call(() -> {
            Sender actualSender = ActualSender.getActualSender(sender, this.globalSender);
            Invocation.Builder request = this.httpClient.signatureServiceRoot().path(target.path(actualSender)).queryParam(POLLING_QUEUE_QUERY_PARAMETER, new Object[]{actualSender.getPollingQueue().value}).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
            try (Response response = request.get();){
                Response.StatusType status = ResponseStatus.resolve(response.getStatus()).throwIf(Response.Status.TOO_MANY_REQUESTS, s -> new TooEagerPollingException()).expect(Response.Status.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientHelper.exceptionForGeneralError(response));
                JobStatusResponse<Object> jobStatusResponse = new JobStatusResponse<Object>(status == Response.Status.NO_CONTENT ? null : response.readEntity(responseClass), ClientHelper.getNextPermittedPollTime(response));
                return jobStatusResponse;
            }
        });
    }

    private static Instant getNextPermittedPollTime(Response response) {
        return ZonedDateTime.parse(response.getHeaderString(NEXT_PERMITTED_POLL_TIME_HEADER), DateTimeFormatter.ISO_DATE_TIME).toInstant();
    }

    public void confirm(Confirmable confirmable) {
        this.call(() -> {
            if (confirmable.getConfirmationReference() != null) {
                URI url = confirmable.getConfirmationReference().getConfirmationUrl();
                LOG.info("Sends confirmation for '{}' to URL {}", (Object)confirmable, (Object)url);
                try (Response response = this.postEmptyEntity(url);){
                    ResponseStatus.resolve(response.getStatus()).expect(Response.Status.Family.SUCCESSFUL).orThrow(status -> ClientHelper.exceptionForGeneralError(response));
                }
            } else {
                LOG.info("Does not need to send confirmation for '{}'", (Object)confirmable);
            }
        });
    }

    private <T> T call(Supplier<T> supplier) {
        return this.clientExceptionMapper.doWithMappedClientException(supplier);
    }

    private void call(Runnable action) {
        this.clientExceptionMapper.doWithMappedClientException(action);
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        this.call(() -> {
            if (deleteDocumentsUrl != null) {
                URI url = deleteDocumentsUrl.getUrl();
                try (Response response = this.delete(url);){
                    ResponseStatus.resolve(response.getStatus()).expect(Response.Status.Family.SUCCESSFUL).orThrow(status -> ClientHelper.exceptionForGeneralError(response));
                }
            } else {
                throw new DocumentsNotDeletableException();
            }
        });
    }

    private Response postEmptyEntity(URI uri) {
        return this.postEntity(uri, null);
    }

    private Response postEntity(URI uri, Object entity) {
        Invocation.Builder requestBuilder = this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        return (entity == null ? requestBuilder.header("Content-Length", (Object)0) : requestBuilder).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_XML_TYPE));
    }

    private Response delete(URI uri) {
        return this.httpClient.target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).delete();
    }

    private static <T> T parseResponse(Response response, Class<T> responseType) {
        ResponseStatus.resolve(response.getStatus()).expect(Response.Status.Family.SUCCESSFUL).orThrow(unexpectedStatus -> ClientHelper.exceptionForGeneralError(response));
        return (T)response.readEntity(responseType);
    }

    private static SignatureException exceptionForGeneralError(Response response) {
        XMLError error = ClientHelper.extractError(response);
        if (ErrorCodes.BROKER_NOT_AUTHORIZED.sameAs(error.getErrorCode())) {
            return new BrokerNotAuthorizedException(error);
        }
        return new UnexpectedResponseException((Object)error, ResponseStatus.resolve(response.getStatus()).get(), new Response.StatusType[]{Response.Status.OK});
    }

    private static XMLError extractError(Response response) {
        XMLError error;
        Optional<String> responseContentType = Optional.ofNullable(response.getHeaderString("Content-Type"));
        if (responseContentType.isPresent() && MediaType.valueOf((String)responseContentType.get()).equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            try {
                response.bufferEntity();
                error = (XMLError)response.readEntity(XMLError.class);
            }
            catch (Exception e) {
                throw new UnexpectedResponseException((Object)("Content-Type " + responseContentType.orElse("unknown") + ": " + Optional.ofNullable((String)response.readEntity(String.class)).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse("<no content in response>")), (Throwable)e, ResponseStatus.resolve(response.getStatus()).get(), new Response.StatusType[]{Response.Status.OK});
            }
        } else {
            throw new UnexpectedResponseException((Object)("Content-Type " + responseContentType.orElse("unknown") + ": " + Optional.ofNullable((String)response.readEntity(String.class)).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse("<no content in response>")), ResponseStatus.resolve(response.getStatus()).get(), new Response.StatusType[]{Response.Status.OK});
        }
        if (error == null) {
            throw new UnexpectedResponseException(null, ResponseStatus.resolve(response.getStatus()).get(), new Response.StatusType[]{Response.Status.OK});
        }
        return error;
    }

    private class UsingBodyParts {
        private final List<BodyPart> parts;

        UsingBodyParts(BodyPart ... parts) {
            this.parts = Arrays.asList(parts);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        <T> T postAsMultiPart(String path, Class<T> responseType) {
            try (MultiPart multiPart = new MultiPart();){
                Object object;
                block14: {
                    for (BodyPart bodyPart : this.parts) {
                        multiPart.bodyPart(bodyPart);
                    }
                    Invocation.Builder request = ClientHelper.this.httpClient.signatureServiceRoot().path(path).request().header("Content-Type", (Object)multiPart.getMediaType()).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
                    Response response = request.post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
                    try {
                        object = ClientHelper.parseResponse(response, responseType);
                        if (response == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return (T)object;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

