/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.http;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import no.digipost.signature.client.core.exceptions.UnexpectedResponseException;

public final class ResponseStatus {
    private final Response.StatusType status;
    private final Predicate<Response.StatusType> statusExpectation;

    public static ResponseStatus resolve(int code) {
        Object status = Response.Status.fromStatusCode((int)code);
        if (status == null) {
            status = Custom.fromStatusCode(code);
        }
        if (status == null) {
            status = ResponseStatus.unknown(code);
        }
        return new ResponseStatus((Response.StatusType)status, s -> true);
    }

    private ResponseStatus(Response.StatusType status, Predicate<Response.StatusType> expectation) {
        this.status = status;
        this.statusExpectation = expectation;
    }

    public ResponseStatus expect(Response.Status.Family expectedStatusFamily) {
        return this.expect((? super Response.StatusType s) -> s.getFamily() == expectedStatusFamily);
    }

    public ResponseStatus expectOneOf(Response.Status.Family ... expectedStatusFamilies) {
        return this.expectOneOf(Stream.of(expectedStatusFamilies), (T family, Response.StatusType status) -> status.getFamily() == family);
    }

    private <T> ResponseStatus expectOneOf(Stream<T> expecteds, BiPredicate<T, Response.StatusType> expectedEvaluator) {
        Predicate<Response.StatusType> oneOfExpectedsAndAlsoExistingExpectation = expecteds.map(expected -> status -> expectedEvaluator.test((Object)expected, (Response.StatusType)status)).reduce(Predicate::or).map(this.statusExpectation::and).orElse(this.statusExpectation);
        return this.expect(oneOfExpectedsAndAlsoExistingExpectation);
    }

    public ResponseStatus expect(Predicate<? super Response.StatusType> expectation) {
        return new ResponseStatus(this.status, this.statusExpectation.and(expectation));
    }

    public <X extends Exception> ResponseStatus throwIf(Response.Status status, Function<Response.StatusType, X> exceptionSupplier) throws X {
        return this.throwIf((? super Response.StatusType s) -> s.equals(status), exceptionSupplier);
    }

    public <X extends Exception> ResponseStatus throwIf(Predicate<? super Response.StatusType> illegalStatus, Function<Response.StatusType, X> exceptionSupplier) throws X {
        if (illegalStatus.test((Response.StatusType)this.status)) {
            throw (Exception)exceptionSupplier.apply(this.status);
        }
        return this;
    }

    public Response.StatusType get() {
        return this.orThrow(s -> new UnexpectedResponseException(this.status));
    }

    public <X extends Exception> Response.StatusType orThrow(Function<Response.StatusType, X> exceptionSuppplier) throws X {
        return this.throwIf(this.statusExpectation.negate(), exceptionSuppplier).status;
    }

    public String toString() {
        return this.status.toString() + (this.statusExpectation.test(this.status) ? "" : " (unexpected)");
    }

    static Response.StatusType unknown(int code) {
        return new Unknown(code);
    }

    public static final class Unknown
    implements Response.StatusType {
        final int code;
        final Response.Status.Family family;
        final String reason;

        private Unknown(int code) {
            this.code = code;
            this.family = Response.Status.Family.familyOf((int)code);
            this.reason = "(" + this.family + ", unrecognized status code)";
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.reason;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public String toString() {
            return this.code + " " + this.reason;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Unknown) {
                Unknown that = (Unknown)obj;
                return Objects.equals(this.code, that.code);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.code);
        }
    }

    public static enum Custom implements Response.StatusType
    {
        UNPROCESSABLE_ENTITY(422, "Unprocessable Entity");

        private int code;
        private String reason;
        private Response.Status.Family family;

        public static Custom fromStatusCode(int code) {
            for (Custom s : Custom.values()) {
                if (s.code != code) continue;
                return s;
            }
            return null;
        }

        private Custom(int code, String reasonPhrase) {
            this.code = code;
            this.reason = reasonPhrase;
            this.family = Response.Status.Family.familyOf((int)code);
        }

        public int getStatusCode() {
            return this.code;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public String getReasonPhrase() {
            return this.reason;
        }

        public String toString() {
            return this.code + " " + this.reason;
        }
    }
}

