/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.core.internal.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import no.digipost.signature.client.Certificates;
import no.digipost.signature.client.core.exceptions.ConfigurationException;
import no.digipost.signature.client.core.internal.security.ProvidesCertificateResourcePaths;

public class TrustStoreLoader {
    public static KeyStore build(ProvidesCertificateResourcePaths hasCertificatePaths) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            for (String certificateFolder : hasCertificatePaths.getCertificatePaths()) {
                TrustStoreLoader.loadCertificatesInto(certificateFolder, trustStore);
            }
            return trustStore;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ConfigurationException("Unable to load certificates into truststore", e);
        }
    }

    private static void loadCertificatesInto(String certificateFolder, final KeyStore trustStore) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        ResourceLoader certificateLoader = certificateFolder.indexOf("classpath:") == 0 ? new ClassPathFileLoader(certificateFolder) : new FileLoader(certificateFolder);
        certificateLoader.forEachFile(new ForFile(){

            @Override
            void call(String fileName, InputStream contents) {
                try {
                    X509Certificate ca = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(contents);
                    trustStore.setCertificateEntry(fileName, ca);
                }
                catch (KeyStoreException | CertificateException e) {
                    throw new ConfigurationException("Unable to load certificate in " + fileName);
                }
            }
        });
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
    }

    private static abstract class ForFile {
        private ForFile() {
        }

        abstract void call(String var1, InputStream var2);
    }

    private static interface ResourceLoader {
        public void forEachFile(ForFile var1) throws IOException;
    }

    private static class FileLoader
    implements ResourceLoader {
        private final File path;

        FileLoader(String certificateFolder) {
            this.path = new File(certificateFolder);
        }

        @Override
        public void forEachFile(ForFile forEachFile) throws IOException {
            if (!this.path.isDirectory()) {
                throw new ConfigurationException("Certificate path '" + this.path + "' is not a directory. It should point to a directory containing certificates.");
            }
            File[] files = this.path.listFiles();
            if (files == null) {
                throw new ConfigurationException("Unable to read certificates from '" + this.path + "'. Make sure it's the correct path.");
            }
            for (File file : files) {
                try (FileInputStream contents = new FileInputStream(file);){
                    forEachFile.call(file.getName(), contents);
                }
            }
        }
    }

    private static class ClassPathFileLoader
    implements ResourceLoader {
        static final String CLASSPATH_PATH_PREFIX = "classpath:";
        private final String certificatePath;

        ClassPathFileLoader(String certificateFolder) {
            this.certificatePath = certificateFolder.substring(CLASSPATH_PATH_PREFIX.length());
        }

        @Override
        public void forEachFile(ForFile forEachFile) throws IOException {
            URL contentsUrl = Certificates.class.getResource(this.certificatePath);
            try (InputStream inputStream = contentsUrl.openStream();){
                forEachFile.call(new File(contentsUrl.getFile()).getName(), inputStream);
            }
        }
    }
}

