/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Optional;
import javax.ws.rs.core.MediaType;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLDirectSignerResponse;
import no.digipost.signature.client.ClientConfiguration;
import no.digipost.signature.client.asice.CreateASiCE;
import no.digipost.signature.client.asice.DocumentBundle;
import no.digipost.signature.client.asice.manifest.CreateDirectManifest;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.ResponseInputStream;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.ClientHelper;
import no.digipost.signature.client.core.internal.JobStatusResponse;
import no.digipost.signature.client.core.internal.http.SignatureHttpClientFactory;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectJobResponse;
import no.digipost.signature.client.direct.DirectJobStatusResponse;
import no.digipost.signature.client.direct.DirectSignerResponse;
import no.digipost.signature.client.direct.JaxbEntityMapping;
import no.digipost.signature.client.direct.StatusReference;
import no.digipost.signature.client.direct.WithSignerUrl;

public class DirectClient {
    private final ClientHelper client;
    private final CreateASiCE<DirectJob> aSiCECreator;
    private final ClientConfiguration clientConfiguration;

    public DirectClient(ClientConfiguration config) {
        this.clientConfiguration = config;
        this.client = new ClientHelper(SignatureHttpClientFactory.create(config), config.getGlobalSender());
        this.aSiCECreator = new CreateASiCE<DirectJob>(new CreateDirectManifest(), config);
    }

    public DirectJobResponse create(DirectJob job) {
        DocumentBundle documentBundle = this.aSiCECreator.createASiCE(job);
        XMLDirectSignatureJobRequest signatureJobRequest = JaxbEntityMapping.toJaxb(job, this.clientConfiguration.getGlobalSender());
        XMLDirectSignatureJobResponse createdJob = this.client.sendSignatureJobRequest(signatureJobRequest, documentBundle, job.getSender());
        return JaxbEntityMapping.fromJaxb(createdJob);
    }

    public DirectSignerResponse requestNewRedirectUrl(WithSignerUrl request) {
        XMLDirectSignerResponse updatedSigner = this.client.requestNewRedirectUrl(request);
        return DirectSignerResponse.fromJaxb(updatedSigner);
    }

    public DirectJobStatusResponse getStatus(StatusReference statusReference) {
        XMLDirectSignatureJobStatusResponse xmlSignatureJobStatusResponse = this.client.sendSignatureJobStatusRequest(statusReference.getStatusUrl());
        return JaxbEntityMapping.fromJaxb(xmlSignatureJobStatusResponse, null);
    }

    public DirectJobStatusResponse getStatusChange() {
        return this.getStatusChange(null);
    }

    public DirectJobStatusResponse getStatusChange(Sender sender) {
        JobStatusResponse<XMLDirectSignatureJobStatusResponse> statusChangeResponse = this.client.getDirectStatusChange(Optional.ofNullable(sender));
        if (statusChangeResponse.gotStatusChange()) {
            return JaxbEntityMapping.fromJaxb(statusChangeResponse.getStatusResponse(), statusChangeResponse.getNextPermittedPollTime());
        }
        return DirectJobStatusResponse.noUpdatedStatus(statusChangeResponse.getNextPermittedPollTime());
    }

    public void confirm(DirectJobStatusResponse receivedStatusResponse) {
        this.client.confirm(receivedStatusResponse);
    }

    public ResponseInputStream getXAdES(XAdESReference xAdESReference) {
        return this.client.getDataStream(xAdESReference.getxAdESUrl(), MediaType.APPLICATION_XML_TYPE);
    }

    public ResponseInputStream getPAdES(PAdESReference pAdESReference) {
        return this.client.getDataStream(pAdESReference.getpAdESUrl(), MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.APPLICATION_XML_TYPE);
    }

    public void deleteDocuments(DeleteDocumentsUrl deleteDocumentsUrl) {
        this.client.deleteDocuments(deleteDocumentsUrl);
    }
}

