/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import no.digipost.signature.client.core.AuthenticationLevel;
import no.digipost.signature.client.core.Document;
import no.digipost.signature.client.core.IdentifierInSignedDocuments;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.SignatureJob;
import no.digipost.signature.client.core.internal.FileName;
import no.digipost.signature.client.core.internal.JobCustomizations;
import no.digipost.signature.client.direct.DirectDocument;
import no.digipost.signature.client.direct.DirectSigner;
import no.digipost.signature.client.direct.StatusRetrievalMethod;
import no.digipost.signature.client.direct.WithExitUrls;

public class DirectJob
implements SignatureJob,
WithExitUrls {
    private final List<DirectDocument> documents;
    private final List<DirectSigner> signers;
    private final String title;
    private final URI completionUrl;
    private final URI rejectionUrl;
    private final URI errorUrl;
    private Optional<String> description = Optional.empty();
    private String reference;
    private Optional<Sender> sender = Optional.empty();
    private Optional<StatusRetrievalMethod> statusRetrievalMethod = Optional.empty();
    private Optional<AuthenticationLevel> requiredAuthentication = Optional.empty();
    private Optional<IdentifierInSignedDocuments> identifierInSignedDocuments = Optional.empty();

    private DirectJob(String title, List<DirectDocument> documents, List<DirectSigner> signers, URI completionUrl, URI rejectionUrl, URI errorUrl) {
        this.title = title;
        this.documents = Collections.unmodifiableList(new ArrayList<DirectDocument>(documents));
        this.signers = Collections.unmodifiableList(new ArrayList<DirectSigner>(signers));
        this.completionUrl = completionUrl;
        this.rejectionUrl = rejectionUrl;
        this.errorUrl = errorUrl;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public List<Document> getDocuments() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < this.documents.size(); ++i) {
            DirectDocument document = this.documents.get(i);
            documents.add(new Document(document.title, document.type.getMediaType(), String.format("%04d", i) + "_" + FileName.reduceToFileNameSafeChars(document.title) + "." + document.type.getFileExtension(), document.content));
        }
        return documents;
    }

    @Override
    public Optional<Sender> getSender() {
        return this.sender;
    }

    @Override
    public URI getCompletionUrl() {
        return this.completionUrl;
    }

    @Override
    public URI getRejectionUrl() {
        return this.rejectionUrl;
    }

    @Override
    public URI getErrorUrl() {
        return this.errorUrl;
    }

    @Override
    public Optional<AuthenticationLevel> getRequiredAuthentication() {
        return this.requiredAuthentication;
    }

    @Override
    public Optional<IdentifierInSignedDocuments> getIdentifierInSignedDocuments() {
        return this.identifierInSignedDocuments;
    }

    public List<DirectSigner> getSigners() {
        return this.signers;
    }

    public Optional<StatusRetrievalMethod> getStatusRetrievalMethod() {
        return this.statusRetrievalMethod;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public static Builder builder(String title, DirectDocument document, DirectSigner signer, WithExitUrls hasExitUrls) {
        return DirectJob.builder(title, Collections.singletonList(document), Collections.singletonList(signer), hasExitUrls);
    }

    public static Builder builder(String title, List<DirectDocument> documents, List<DirectSigner> signers, WithExitUrls hasExitUrls) {
        return new Builder(title, documents, signers, hasExitUrls.getCompletionUrl(), hasExitUrls.getRejectionUrl(), hasExitUrls.getErrorUrl());
    }

    public static class Builder
    implements JobCustomizations<Builder> {
        private final DirectJob target;
        private boolean built = false;

        private Builder(String title, List<DirectDocument> documents, List<DirectSigner> signers, URI completionUrl, URI rejectionUrl, URI errorUrl) {
            this.target = new DirectJob(title, documents, signers, completionUrl, rejectionUrl, errorUrl);
        }

        @Override
        public Builder withReference(UUID uuid) {
            return this.withReference(uuid.toString());
        }

        public Builder withDescription(String description) {
            this.target.description = Optional.of(description);
            return this;
        }

        @Override
        public Builder withReference(String reference) {
            this.target.reference = reference;
            return this;
        }

        @Override
        public Builder withSender(Sender sender) {
            this.target.sender = Optional.of(sender);
            return this;
        }

        @Override
        public Builder requireAuthentication(AuthenticationLevel level) {
            this.target.requiredAuthentication = Optional.of(level);
            return this;
        }

        @Override
        public Builder withIdentifierInSignedDocuments(IdentifierInSignedDocuments identifier) {
            this.target.identifierInSignedDocuments = Optional.of(identifier);
            return this;
        }

        public Builder retrieveStatusBy(StatusRetrievalMethod statusRetrievalMethod) {
            this.target.statusRetrievalMethod = Optional.of(statusRetrievalMethod);
            return this;
        }

        public DirectJob build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

