/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import no.digipost.signature.client.core.internal.PersonalIdentificationNumbers;
import no.digipost.signature.client.direct.DirectSignerResponse;

public class DirectJobResponse {
    private final long signatureJobId;
    private final String reference;
    private final List<DirectSignerResponse> signers;
    private final URI statusUrl;

    public DirectJobResponse(long signatureJobId, String reference, URI statusUrl, List<DirectSignerResponse> signers) {
        this.signatureJobId = signatureJobId;
        this.reference = reference;
        this.signers = signers;
        this.statusUrl = statusUrl;
    }

    public long getSignatureJobId() {
        return this.signatureJobId;
    }

    public String getReference() {
        return this.reference;
    }

    public DirectSignerResponse getSingleSigner() {
        if (this.signers.size() != 1) {
            throw new IllegalStateException("Calls to this method should only be done when there are no more than one signer.");
        }
        return this.signers.get(0);
    }

    public List<DirectSignerResponse> getSigners() {
        return this.signers;
    }

    public DirectSignerResponse getSignerIdentifiedBy(String identifier) {
        return this.findSignerIdentifiedBy(identifier).orElseThrow(() -> new NoSuchElementException("signer with identifier " + PersonalIdentificationNumbers.mask(identifier) + " in job " + this.signatureJobId + (this.reference != null ? " (reference: " + this.reference + ")" : "") + "."));
    }

    public Optional<DirectSignerResponse> findSignerIdentifiedBy(String identifier) {
        return this.getSigners().stream().filter(signer -> signer.hasIdentifier(identifier)).findFirst();
    }

    public URI getStatusUrl() {
        return this.statusUrl;
    }
}

