/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.util.Optional;
import no.digipost.signature.client.core.OnBehalfOf;
import no.digipost.signature.client.core.SignatureType;
import no.digipost.signature.client.core.internal.PersonalIdentificationNumbers;
import no.digipost.signature.client.core.internal.SignerCustomizations;

public class DirectSigner {
    private final String personalIdentificationNumber;
    private final String customIdentifier;
    private final Optional<SignatureType> signatureType;
    private final Optional<OnBehalfOf> onBehalfOf;

    public static Builder withPersonalIdentificationNumber(String personalIdentificationNumber) {
        return new Builder(personalIdentificationNumber, null);
    }

    public static Builder withCustomIdentifier(String customIdentifier) {
        return new Builder(null, customIdentifier);
    }

    private DirectSigner(String personalIdentificationNumber, String customIdentifier, Optional<SignatureType> signatureType, Optional<OnBehalfOf> onBehalfOf) {
        this.personalIdentificationNumber = personalIdentificationNumber;
        this.customIdentifier = customIdentifier;
        this.signatureType = signatureType;
        this.onBehalfOf = onBehalfOf;
    }

    public boolean isIdentifiedByPersonalIdentificationNumber() {
        return this.personalIdentificationNumber != null;
    }

    public String getPersonalIdentificationNumber() {
        if (!this.isIdentifiedByPersonalIdentificationNumber()) {
            throw new IllegalStateException(this + " is not identified by personal identification number, use getCustomIdentifier() instead.");
        }
        return this.personalIdentificationNumber;
    }

    public String getCustomIdentifier() {
        if (this.customIdentifier == null) {
            throw new IllegalStateException(this + " is not identified by a custom identifier, use getPersonalIdentificationNumber() instead.");
        }
        return this.customIdentifier;
    }

    public Optional<SignatureType> getSignatureType() {
        return this.signatureType;
    }

    public Optional<OnBehalfOf> getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public String toString() {
        return DirectSigner.class.getSimpleName() + ": " + (this.isIdentifiedByPersonalIdentificationNumber() ? PersonalIdentificationNumbers.mask(this.personalIdentificationNumber) : this.customIdentifier);
    }

    public static final class Builder
    implements SignerCustomizations<Builder> {
        private String personalIdentificationNumber;
        private String customIdentifier;
        private Optional<SignatureType> signatureType = Optional.empty();
        private Optional<OnBehalfOf> onBehalfOf = Optional.empty();

        private Builder(String personalIdentificationNumber, String customIdentifier) {
            this.personalIdentificationNumber = personalIdentificationNumber;
            this.customIdentifier = customIdentifier;
        }

        @Override
        public Builder withSignatureType(SignatureType type) {
            this.signatureType = Optional.of(type);
            return this;
        }

        @Override
        public Builder onBehalfOf(OnBehalfOf onBehalfOf) {
            this.onBehalfOf = Optional.of(onBehalfOf);
            return this;
        }

        public DirectSigner build() {
            return new DirectSigner(this.personalIdentificationNumber, this.customIdentifier, this.signatureType, this.onBehalfOf);
        }
    }
}

