/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.util.Objects;
import no.digipost.signature.api.xml.XMLDirectSignerResponse;
import no.digipost.signature.client.direct.WithSignerUrl;

public class DirectSignerResponse
implements WithSignerUrl {
    private final String personalIdentificationNumber;
    private final String customIdentifier;
    private final URI signerUrl;
    private final URI redirectUrl;

    public static DirectSignerResponse fromJaxb(XMLDirectSignerResponse signer) {
        if (signer.getPersonalIdentificationNumber() != null) {
            return new DirectSignerResponse(signer.getPersonalIdentificationNumber(), null, signer.getHref(), signer.getRedirectUrl());
        }
        if (signer.getSignerIdentifier() != null) {
            return new DirectSignerResponse(null, signer.getSignerIdentifier(), signer.getHref(), signer.getRedirectUrl());
        }
        throw new IllegalStateException("Unable to convert from " + XMLDirectSignerResponse.class.getSimpleName() + " to " + DirectSignerResponse.class.getSimpleName() + ", because both personalIdentificationNumber and signerIdentifier was null");
    }

    DirectSignerResponse(String personalIdentificationNumber, String customIdentifier, URI signerUrl, URI redirectUrl) {
        this.personalIdentificationNumber = personalIdentificationNumber;
        this.customIdentifier = customIdentifier;
        this.signerUrl = signerUrl;
        this.redirectUrl = redirectUrl;
    }

    public boolean hasIdentifier(String identifier) {
        return Objects.equals(this.personalIdentificationNumber, identifier) || Objects.equals(this.customIdentifier, identifier);
    }

    public boolean isIdentifiedByPersonalIdentificationNumber() {
        return this.personalIdentificationNumber != null;
    }

    public String getPersonalIdentificationNumber() {
        if (!this.isIdentifiedByPersonalIdentificationNumber()) {
            throw new IllegalStateException(this + " is not identified by personal identification number, use getCustomIdentifier() instead.");
        }
        return this.personalIdentificationNumber;
    }

    public String getCustomIdentifier() {
        if (this.customIdentifier == null) {
            throw new IllegalStateException(this + " is not identified by a custom identifier, use getPersonalIdentificationNumber() instead.");
        }
        return this.customIdentifier;
    }

    @Override
    public URI getSignerUrl() {
        return this.signerUrl;
    }

    public URI getRedirectUrl() {
        return this.redirectUrl;
    }
}

