/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import no.digipost.signature.api.xml.XMLDirectSignatureJobRequest;
import no.digipost.signature.api.xml.XMLDirectSignatureJobResponse;
import no.digipost.signature.api.xml.XMLDirectSignatureJobStatusResponse;
import no.digipost.signature.api.xml.XMLExitUrls;
import no.digipost.signature.api.xml.XMLSignerSpecificUrl;
import no.digipost.signature.api.xml.XMLSignerStatus;
import no.digipost.signature.api.xml.XMLStatusRetrievalMethod;
import no.digipost.signature.client.core.ConfirmationReference;
import no.digipost.signature.client.core.DeleteDocumentsUrl;
import no.digipost.signature.client.core.PAdESReference;
import no.digipost.signature.client.core.Sender;
import no.digipost.signature.client.core.XAdESReference;
import no.digipost.signature.client.core.internal.ActualSender;
import no.digipost.signature.client.direct.DirectJob;
import no.digipost.signature.client.direct.DirectJobResponse;
import no.digipost.signature.client.direct.DirectJobStatus;
import no.digipost.signature.client.direct.DirectJobStatusResponse;
import no.digipost.signature.client.direct.DirectSignerResponse;
import no.digipost.signature.client.direct.Signature;
import no.digipost.signature.client.direct.SignerStatus;
import no.digipost.signature.client.direct.StatusRetrievalMethod;

final class JaxbEntityMapping {
    JaxbEntityMapping() {
    }

    static XMLDirectSignatureJobRequest toJaxb(DirectJob signatureJob, Optional<Sender> globalSender) {
        Sender actualSender = ActualSender.getActualSender(signatureJob.getSender(), globalSender);
        return new XMLDirectSignatureJobRequest().withReference(signatureJob.getReference()).withExitUrls(new XMLExitUrls().withCompletionUrl(signatureJob.getCompletionUrl()).withRejectionUrl(signatureJob.getRejectionUrl()).withErrorUrl(signatureJob.getErrorUrl())).withStatusRetrievalMethod((XMLStatusRetrievalMethod)signatureJob.getStatusRetrievalMethod().map(StatusRetrievalMethod::getXmlEnumValue).orElse(null)).withPollingQueue(actualSender.getPollingQueue().value);
    }

    static DirectJobResponse fromJaxb(XMLDirectSignatureJobResponse job) {
        List<DirectSignerResponse> signers = job.getSigners().stream().map(DirectSignerResponse::fromJaxb).collect(Collectors.toList());
        return new DirectJobResponse(job.getSignatureJobId(), job.getReference(), job.getStatusUrl(), signers);
    }

    static DirectJobStatusResponse fromJaxb(XMLDirectSignatureJobStatusResponse statusResponse, Instant nextPermittedPollTime) {
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        for (XMLSignerStatus signerStatus : statusResponse.getStatuses()) {
            URI xAdESUrl = statusResponse.getXadesUrls().stream().filter(JaxbEntityMapping.forSigner(signerStatus.getSigner())).findFirst().map(XMLSignerSpecificUrl::getValue).orElse(null);
            signatures.add(new Signature(signerStatus.getSigner(), SignerStatus.of(signerStatus.getValue()), signerStatus.getSince().toInstant(), XAdESReference.of(xAdESUrl)));
        }
        return new DirectJobStatusResponse(statusResponse.getSignatureJobId(), statusResponse.getReference(), DirectJobStatus.fromXmlType(statusResponse.getSignatureJobStatus()), ConfirmationReference.of(statusResponse.getConfirmationUrl()), DeleteDocumentsUrl.of(statusResponse.getDeleteDocumentsUrl()), signatures, PAdESReference.of(statusResponse.getPadesUrl()), nextPermittedPollTime);
    }

    private static Predicate<XMLSignerSpecificUrl> forSigner(String signer) {
        return url -> url.getSigner().equals(signer);
    }
}

