/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.signature.client.direct;

import java.net.URI;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;
import no.digipost.signature.client.direct.DirectJobResponse;

public class StatusReference {
    public static final String STATUS_QUERY_TOKEN_PARAM_NAME = "status_query_token";
    private final URI statusUrl;
    private final String statusQueryToken;

    public static StatusUrlContruction of(DirectJobResponse response) {
        return StatusReference.ofUrl(response.getStatusUrl());
    }

    public static StatusUrlContruction ofUrl(final URI statusUrl) {
        return new StatusUrlContruction(){

            @Override
            public StatusReference withStatusQueryToken(String token) {
                return new StatusReference(statusUrl, token);
            }
        };
    }

    private StatusReference(URI statusUrl, String statusQueryToken) {
        this.statusUrl = statusUrl;
        this.statusQueryToken = Objects.requireNonNull(statusQueryToken, STATUS_QUERY_TOKEN_PARAM_NAME);
    }

    public URI getStatusUrl() {
        return UriBuilder.fromUri((URI)this.statusUrl).queryParam(STATUS_QUERY_TOKEN_PARAM_NAME, new Object[]{this.statusQueryToken}).build(new Object[0]);
    }

    public static abstract class StatusUrlContruction {
        private StatusUrlContruction() {
        }

        public abstract StatusReference withStatusQueryToken(String var1);
    }
}

